<?php 

/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */ 

function optionsframework_option_name() {
	// Change this to use your theme slug
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );
	return $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'skt-yogi'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {
	//array of all custom font types.
	$font_types = array( '' => '', 'Arial' => 'Arial',
		'Comic Sans MS' => 'Comic Sans MS',
		'FreeSans' => 'FreeSans',
		'Georgia' => 'Georgia',
		'Lucida Sans Unicode' => 'Lucida Sans Unicode',
		'Palatino Linotype' => 'Palatino Linotype',
		'Symbol' => 'Symbol',
		'Tahoma' => 'Tahoma',
		'Trebuchet MS' => 'Trebuchet MS',
		'Verdana' => 'Verdana',
		'ABeeZee' => 'ABeeZee',
		'Abel' => 'Abel',
		'Abril Fatface' => 'Abril Fatface',
		'Aclonica' => 'Aclonica',
		'Acme' => 'Acme',
		'Actor' => 'Actor',
		'Adamina' => 'Adamina',
		'Advent Pro' => 'Advent Pro',
		'Aguafina Script' => 'Aguafina Script',
		'Akronim' => 'Akronim',
		'Aladin' => 'Aladin',
		'Aldrich' => 'Aldrich',
		'Alegreya' => 'Alegreya',
		'Alegreya SC' => 'Alegreya SC',
		'Alex Brush' => 'Alex Brush',
		'Alfa Slab One' => 'Alfa Slab One',
		'Alice' => 'Alice',
		'Alike' => 'Alike',
		'Alike Angular' => 'Alike Angular',
		'Allan' => 'Allan',
		'Allerta' => 'Allerta',
		'Allerta Stencil' => 'Allerta Stencil',
		'Allura' => 'Allura',
		'Almendra' => 'Almendra',
		'Almendra Display' => 'Almendra Display',
		'Almendra SC' => 'Almendra SC',
		'Amarante' => 'Amarante',
		'Amaranth' => 'Amaranth',
		'Amatic SC' => 'Amatic SC',
		'Amethysta' => 'Amethysta',
		'Anaheim' => 'Anaheim',
		'Andada' => 'Andada',
		'Andika' => 'Andika',
		'Annie Use Your Telescope' => 'Annie Use Your Telescope',
		'Anonymous Pro' => 'Anonymous Pro',
		'Antic' => 'Antic',
		'Antic Didone' => 'Antic Didone',
		'Antic Slab' => 'Antic Slab',
		'Anton' => 'Anton',
		'Arapey' => 'Arapey',
		'Arbutus' => 'Arbutus',
		'Arbutus Slab' => 'Arbutus Slab',
		'Architects Daughter' => 'Architects Daughter',
		'Archivo White' => 'Archivo White',
		'Archivo Narrow' => 'Archivo Narrow',
		'Arimo' => 'Arimo',
		'Arizonia' => 'Arizonia',
		'Armata' => 'Armata',
		'Artifika' => 'Artifika',
		'Arvo' => 'Arvo',
		'Asap' => 'Asap',
		'Asset' => 'Asset',
		'Astloch' => 'Astloch',
		'Asul' => 'Asul',
		'Atomic Age' => 'Atomic Age',
		'Aubrey' => 'Aubrey',
		'Audiowide' => 'Audiowide',
		'Autour One' => 'Autour One',
		'Average' => 'Average',
		'Average Sans' => 'Average Sans',
		'Averia Gruesa Libre' => 'Averia Gruesa Libre',
		'Averia Libre' => 'Averia Libre',
		'Averia Sans Libre' => 'Averia Sans Libre',
		'Averia Serif Libre' => 'Averia Serif Libre',
		'Bad Script' => 'Bad Script',
		'Balthazar' => 'Balthazar',
		'Bangers' => 'Bangers',
		'Basic' => 'Basic',
		'Baumans' => 'Baumans',
		'Belgrano' => 'Belgrano',
		'Belleza' => 'Belleza',
		'BenchNine' => 'BenchNine',
		'Bentham' => 'Bentham',
		'Berkshire Swash' => 'Berkshire Swash',
		'Bevan' => 'Bevan',
		'Bigelow Rules' => 'Bigelow Rules',
		'Bigshot One' => 'Bigshot One',
		'Bilbo' => 'Bilbo',
		'Bilbo Swash Caps' => 'Bilbo Swash Caps',
		'Bitter' => 'Bitter',
		'White Ops One' => 'White Ops One',
		'Bonbon' => 'Bonbon',
		'Boogaloo' => 'Boogaloo',
		'Bowlby One' => 'Bowlby One',
		'Bowlby One SC' => 'Bowlby One SC',
		'Brawler' => 'Brawler',
		'Bree Serif' => 'Bree Serif',
		'Bubblegum Sans' => 'Bubblegum Sans',
		'Bubbler One' => 'Bubbler One',
		'Buda' => 'Buda',
		'Buenard' => 'Buenard',
		'Butcherman' => 'Butcherman',
		'Butcherman Caps' => 'Butcherman Caps',
		'Butterfly Kids' => 'Butterfly Kids',
		'Cabin' => 'Cabin',
		'Cabin Condensed' => 'Cabin Condensed',
		'Cabin Sketch' => 'Cabin Sketch',
		'Cabin' => 'Cabin',
		'Caesar Dressing' => 'Caesar Dressing',
		'Cagliostro' => 'Cagliostro',
		'Calligraffitti' => 'Calligraffitti',
		'Cambo' => 'Cambo',
		'Candal' => 'Candal',
		'Cantarell' => 'Cantarell',
		'Cantata One' => 'Cantata One',
		'Cantora One' => 'Cantora One',
		'Capriola' => 'Capriola',
		'Cardo' => 'Cardo',
		'Carme' => 'Carme',
		'Carrois Gothic' => 'Carrois Gothic',
		'Carrois Gothic SC' => 'Carrois Gothic SC',
		'Carter One' => 'Carter One',
		'Caudex' => 'Caudex',
		'Cedarville Cursive' => 'Cedarville Cursive',
		'Ceviche One' => 'Ceviche One',
		'Changa One' => 'Changa One',
		'Chango' => 'Chango',
		'Chau Philomene One' => 'Chau Philomene One',
		'Chela One' => 'Chela One',
		'Chelsea Market' => 'Chelsea Market',
		'Cherry Cream Soda' => 'Cherry Cream Soda',
		'Cherry Swash' => 'Cherry Swash',
		'Chewy' => 'Chewy',
		'Chicle' => 'Chicle',
		'Chivo' => 'Chivo',
		'Cinzel' => 'Cinzel',
		'Cinzel Decorative' => 'Cinzel Decorative',
		'Clicker Script' => 'Clicker Script',
		'Coda' => 'Coda',
		'Codystar' => 'Codystar',
		'Combo' => 'Combo',
		'Comfortaa' => 'Comfortaa',
		'Coming Soon' => 'Coming Soon',
		'Condiment' => 'Condiment',
		'Contrail One' => 'Contrail One',
		'Convergence' => 'Convergence',
		'Cookie' => 'Cookie',
		'Copse' => 'Copse',
		'Corben' => 'Corben',
		'Courgette' => 'Courgette',
		'Cousine' => 'Cousine',
		'Coustard' => 'Coustard',
		'Covered By Your Grace' => 'Covered By Your Grace',
		'Crafty Girls' => 'Crafty Girls',
		'Creepster' => 'Creepster',
		'Creepster Caps' => 'Creepster Caps',
		'Crete Round' => 'Crete Round',
		'Crimson' => 'Crimson',
		'Croissant One' => 'Croissant One',
		'Crushed' => 'Crushed',
		'Cuprum' => 'Cuprum',
		'Cutive' => 'Cutive',
		'Cutive Mono' => 'Cutive Mono',
		'Damion' => 'Damion',
		'Dancing Script' => 'Dancing Script',
		'Dawning of a New Day' => 'Dawning of a New Day',
		'Days One' => 'Days One',
		'Delius' => 'Delius',
		'Delius Swash Caps' => 'Delius Swash Caps',
		'Delius Unicase' => 'Delius Unicase',
		'Della Respira' => 'Della Respira',
		'Denk One' => 'Denk One',
		'Devonshire' => 'Devonshire',
		'Didact Gothic' => 'Didact Gothic',
		'Diplomata' => 'Diplomata',
		'Diplomata SC' => 'Diplomata SC',
		'Domine' => 'Domine',
		'Donegal One' => 'Donegal One',
		'Doppio One' => 'Doppio One',
		'Dorsa' => 'Dorsa',
		'Dosis' => 'Dosis',
		'Dr Sugiyama' => 'Dr Sugiyama',
		'Droid Sans' => 'Droid Sans',
		'Droid Sans Mono' => 'Droid Sans Mono',
		'Droid Serif' => 'Droid Serif',
		'Duru Sans' => 'Duru Sans',
		'Dynalight' => 'Dynalight',
		'EB Garamond' => 'EB Garamond',
		'Eagle Lake' => 'Eagle Lake',
		'Eater' => 'Eater',
		'Eater Caps' => 'Eater Caps',
		'Economica' => 'Economica',
		'Electrolize' => 'Electrolize',
		'Elsie' => 'Elsie',
		'Elsie Swash Caps' => 'Elsie Swash Caps',
		'Emblema One' => 'Emblema One',
		'Emilys Candy' => 'Emilys Candy',
		'Engagement' => 'Engagement',
		'Englebert' => 'Englebert',
		'Enriqueta' => 'Enriqueta',
		'Erica One' => 'Erica One',
		'Esteban' => 'Esteban',
		'Euphoria Script' => 'Euphoria Script',
		'Ewert' => 'Ewert',
		'Exo' => 'Exo',
		'Expletus Sans' => 'Expletus Sans',
		'Fanwood Text' => 'Fanwood Text',
		'Fascinate' => 'Fascinate',
		'Fascinate Inline' => 'Fascinate Inline',
		'Faster One' => 'Faster One',
		'Federant' => 'Federant',
		'Federo' => 'Federo',
		'Felipa' => 'Felipa',
		'Fenix' => 'Fenix',
		'Finger Paint' => 'Finger Paint',
		'Fjalla One' => 'Fjalla One',
		'Fjord One' => 'Fjord One',
		'Flamenco' => 'Flamenco',
		'Flavors' => 'Flavors',
		'Fondamento' => 'Fondamento',
		'Fontdiner Swanky' => 'Fontdiner Swanky',
		'Forum' => 'Forum',
		'Francois One' => 'Francois One',
		'Freckle Face' => 'Freckle Face',
		'Fredericka the Great' => 'Fredericka the Great',
		'Fredoka One' => 'Fredoka One',
		'Fresca' => 'Fresca',
		'Frijole' => 'Frijole',
		'Fruktur' => 'Fruktur',
		'Fugaz One' => 'Fugaz One',
		'Gafata' => 'Gafata',
		'Galdeano' => 'Galdeano',
		'Galindo' => 'Galindo',
		'Gentium Basic' => 'Gentium Basic',
		'Gentium Book Basic' => 'Gentium Book Basic',
		'Geo' => 'Geo',
		'Geostar' => 'Geostar',
		'Geostar Fill' => 'Geostar Fill',
		'Germania One' => 'Germania One',
		'Gilda Display' => 'Gilda Display',
		'Give You Glory' => 'Give You Glory',
		'Glass Antiqua' => 'Glass Antiqua',
		'Glegoo' => 'Glegoo',
		'Gloria Hallelujah' => 'Gloria Hallelujah',
		'Goblin One' => 'Goblin One',
		'Gochi Hand' => 'Gochi Hand',
		'Gorditas' => 'Gorditas',
		'Goudy Bookletter 1911' => 'Goudy Bookletter 1911',
		'Graduate' => 'Graduate',
		'Grand Hotel' => 'Grand Hotel',
		'Gravitas One' => 'Gravitas One',
		'Great Vibes' => 'Great Vibes',
		'Griffy' => 'Griffy',
		'Gruppo' => 'Gruppo',
		'Gudea' => 'Gudea',
		'Habibi' => 'Habibi',
		'Hammersmith One' => 'Hammersmith One',
		'Hanalei' => 'Hanalei',
		'Hanalei Fill' => 'Hanalei Fill',
		'Handlee' => 'Handlee',
		'Happy Monkey' => 'Happy Monkey',
		'Headland One' => 'Headland One',
		'Henny Penny' => 'Henny Penny',
		'Herr Von Muellerhoff' => 'Herr Von Muellerhoff',
		'Holtwood One SC' => 'Holtwood One SC',
		'Homemade Apple' => 'Homemade Apple',
		'Homenaje' => 'Homenaje',
		'IM Fell' => 'IM Fell',
		'Iceberg' => 'Iceberg',
		'Iceland' => 'Iceland',
		'Imprima' => 'Imprima',
		'Inconsolata' => 'Inconsolata',
		'Inder' => 'Inder',
		'Indie Flower' => 'Indie Flower',
		'Inika' => 'Inika',
		'Irish Growler' => 'Irish Growler',
		'Istok Web' => 'Istok Web',
		'Italiana' => 'Italiana',
		'Italianno' => 'Italianno',
		'Jacques Francois' => 'Jacques Francois',
		'Jacques Francois Shadow' => 'Jacques Francois Shadow',
		'Jim Nightshade' => 'Jim Nightshade',
		'Jockey One' => 'Jockey One',
		'Jolly Lodger' => 'Jolly Lodger',
		'Josefin Sans' => 'Josefin Sans',
		'Josefin Sans' => 'Josefin Sans',
		'Josefin Slab' => 'Josefin Slab',
		'Joti One' => 'Joti One',
		'Judson' => 'Judson',
		'Julee' => 'Julee',
		'Julius Sans One' => 'Julius Sans One',
		'Junge' => 'Junge',
		'Jura' => 'Jura',
		'Just Another Hand' => 'Just Another Hand',
		'Just Me Again Down Here' => 'Just Me Again Down Here',
		'Kameron' => 'Kameron',
		'Karla' => 'Karla',
		'Kaushan Script' => 'Kaushan Script',
		'Kavoon' => 'Kavoon',
		'Keania One' => 'Keania One',
		'Kelly Slab' => 'Kelly Slab',
		'Kenia' => 'Kenia',
		'Kite One' => 'Kite One',
		'Knewave' => 'Knewave',
		'Kotta One' => 'Kotta One',
		'Kranky' => 'Kranky',
		'Kreon' => 'Kreon',
		'Kristi' => 'Kristi',
		'Krona One' => 'Krona One',
		'La Belle Aurore' => 'La Belle Aurore',
		'Lancelot' => 'Lancelot',
		'Lato' => 'Lato',
		'League Script' => 'League Script',
		'Leckerli One' => 'Leckerli One',
		'Ledger' => 'Ledger',
		'Lekton' => 'Lekton',
		'Lemon' => 'Lemon',
		'Libre Baskerville' => 'Libre Baskerville',
		'Life Savers' => 'Life Savers',
		'Lilita One' => 'Lilita One',
		'Limelight' => 'Limelight',
		'Linden Hill' => 'Linden Hill',
		'Lobster' => 'Lobster',
		'Lobster Two' => 'Lobster Two',
		'Londrina Outline' => 'Londrina Outline',
		'Londrina Shadow' => 'Londrina Shadow',
		'Londrina Sketch' => 'Londrina Sketch',
		'Londrina Solid' => 'Londrina Solid',
		'Lora' => 'Lora',
		'Love Ya Like A Sister' => 'Love Ya Like A Sister',
		'Loved by the King' => 'Loved by the King',
		'Lovers Quarrel' => 'Lovers Quarrel',
		'Luckiest Guy' => 'Luckiest Guy',
		'Lusitana' => 'Lusitana',
		'Lustria' => 'Lustria',
		'Macondo' => 'Macondo',
		'Macondo Swash Caps' => 'Macondo Swash Caps',
		'Magra' => 'Magra',
		'Maiden Orange' => 'Maiden Orange',
		'Mako' => 'Mako',
		'Marcellus' => 'Marcellus',
		'Marcellus SC' => 'Marcellus SC',
		'Marck Script' => 'Marck Script',
		'Margarine' => 'Margarine',
		'Marko One' => 'Marko One',
		'Marmelad' => 'Marmelad',
		'Marvel' => 'Marvel',
		'Mate' => 'Mate',
		'Mate SC' => 'Mate SC',
		'Maven Pro' => 'Maven Pro',
		'McLaren' => 'McLaren',
		'Meddon' => 'Meddon',
		'MedievalSharp' => 'MedievalSharp',
		'Medula One' => 'Medula One',
		'Megrim' => 'Megrim',
		'Meie Script' => 'Meie Script',
		'Merienda' => 'Merienda',
		'Merienda One' => 'Merienda One',
		'Merriweather' => 'Merriweather',
		'Metal Mania' => 'Metal Mania',
		'Metamorphous' => 'Metamorphous',
		'Metrophobic' => 'Metrophobic',
		'Michroma' => 'Michroma',
		'Milonga' => 'Milonga',
		'Miltonian' => 'Miltonian',
		'Miltonian Tattoo' => 'Miltonian Tattoo',
		'Miniver' => 'Miniver',
		'Miss Fajardose' => 'Miss Fajardose',
		'Miss Saint Delafield' => 'Miss Saint Delafield',
		'Modern Antiqua' => 'Modern Antiqua',
		'Molengo' => 'Molengo',
		'Molle' => 'Molle',
		'Monda' => 'Monda',
		'Monofett' => 'Monofett',
		'Monoton' => 'Monoton',
		'Monsieur La Doulaise' => 'Monsieur La Doulaise',
		'Montaga' => 'Montaga',
		'Montez' => 'Montez',
		'Montserrat' => 'Montserrat',
		'Montserrat Alternates' => 'Montserrat Alternates',
		'Montserrat Subrayada' => 'Montserrat Subrayada',
		'Mountains of Christmas' => 'Mountains of Christmas',
		'Mouse Memoirs' => 'Mouse Memoirs',
		'Mr Bedford' => 'Mr Bedford',
		'Mr Bedfort' => 'Mr Bedfort',
		'Mr Dafoe' => 'Mr Dafoe',
		'Mr De Haviland' => 'Mr De Haviland',
		'Mrs Saint Delafield' => 'Mrs Saint Delafield',
		'Mrs Sheppards' => 'Mrs Sheppards',
		'Muli' => 'Muli',
		'Mystery Quest' => 'Mystery Quest',
		'Neucha' => 'Neucha',
		'Neuton' => 'Neuton',
		'New Rocker' => 'New Rocker',
		'News Cycle' => 'News Cycle',
		'Niconne' => 'Niconne',
		'Nixie One' => 'Nixie One',
		'Nobile' => 'Nobile',
		'Norican' => 'Norican',
		'Nosifer' => 'Nosifer',
		'Nosifer Caps' => 'Nosifer Caps',
		'Noticia Text' => 'Noticia Text',
		'Nova Round' => 'Nova Round',
		'Numans' => 'Numans',
		'Nunito' => 'Nunito',
		'Offside' => 'Offside',
		'Oldenburg' => 'Oldenburg',
		'Oleo Script' => 'Oleo Script',
		'Oleo Script Swash Caps' => 'Oleo Script Swash Caps',
		'Open Sans' => 'Open Sans',
		'Open Sans Condensed' => 'Open Sans Condensed',
		'Oranienbaum' => 'Oranienbaum',
		'Orbitron' => 'Orbitron',
		'Oregano' => 'Oregano',
		'Orienta' => 'Orienta',
		'Original Surfer' => 'Original Surfer',
		'Oswald' => 'Oswald',
		'Over the Rainbow' => 'Over the Rainbow',
		'Overlock' => 'Overlock',
		'Overlock SC' => 'Overlock SC',
		'Ovo' => 'Ovo',
		'Oxygen' => 'Oxygen',
		'Oxygen Mono' => 'Oxygen Mono',
		'PT Mono' => 'PT Mono',
		'PT Sans' => 'PT Sans',
		'PT Sans Narrow' => 'PT Sans Narrow',
		'PT Serif' => 'PT Serif',
		'PT Serif Caption' => 'PT Serif Caption',
		'Pacifico' => 'Pacifico',
		'Paprika' => 'Paprika',
		'Parisienne' => 'Parisienne',
		'Passero One' => 'Passero One',
		'Passion One' => 'Passion One',
		'Patrick Hand' => 'Patrick Hand',
		'Patua One' => 'Patua One',
		'Paytone One' => 'Paytone One',
		'Peralta' => 'Peralta',
		'Permanent Marker' => 'Permanent Marker',
		'Petit Formal Script' => 'Petit Formal Script',
		'Petrona' => 'Petrona',
		'Philosopher' => 'Philosopher',
		'Piedra' => 'Piedra',
		'Pinyon Script' => 'Pinyon Script',
		'Pirata One' => 'Pirata One',
		'Plaster' => 'Plaster',
		'Play' => 'Play',
		'Playball' => 'Playball',
		'Playfair Display' => 'Playfair Display',
		'Playfair Display SC' => 'Playfair Display SC',
		'Podkova' => 'Podkova',
		'Poiret One' => 'Poiret One',
		'Poller One' => 'Poller One',
		'Poly' => 'Poly',
		'Pompiere' => 'Pompiere',
		'Pontano Sans' => 'Pontano Sans',
		'Port Lligat Sans' => 'Port Lligat Sans',
		'Port Lligat Slab' => 'Port Lligat Slab',
		'Prata' => 'Prata',
		'Press Start 2P' => 'Press Start 2P',
		'Princess Sofia' => 'Princess Sofia',
		'Prociono' => 'Prociono',
		'Prosto One' => 'Prosto One',
		'Puritan' => 'Puritan',
		'Purple Purse' => 'Purple Purse',
		'Quando' => 'Quando',
		'Quantico' => 'Quantico',
		'Quattrocento' => 'Quattrocento',
		'Quattrocento Sans' => 'Quattrocento Sans',
		'Questrial' => 'Questrial',
		'Quicksand' => 'Quicksand',
		'Quintessential' => 'Quintessential',
		'Qwigley' => 'Qwigley',
		'Racing Sans One' => 'Racing Sans One',
		'Radley' => 'Radley',
		'Raleway Dots' => 'Raleway Dots',
		'Raleway' => 'Raleway',
		'Rambla' => 'Rambla',
		'Rammetto One' => 'Rammetto One',
		'Ranchers' => 'Ranchers',
		'Rancho' => 'Rancho',
		'Rationale' => 'Rationale',
		'Redressed' => 'Redressed',
		'Reenie Beanie' => 'Reenie Beanie',
		'Revalia' => 'Revalia',
		'Ribeye' => 'Ribeye',
		'Ribeye Marrow' => 'Ribeye Marrow',
		'Righteous' => 'Righteous',
		'Risque' => 'Risque',
		'Roboto' => 'Roboto',
		'Roboto Condensed' => 'Roboto Condensed',
		'Roboto Condensed Light' => 'Roboto Condensed Light',
		'Rochester' => 'Rochester',
		'Rock Salt' => 'Rock Salt',
		'Rokkitt' => 'Rokkitt',
		'Romanesco' => 'Romanesco',
		'Ropa Sans' => 'Ropa Sans',
		'Rosario' => 'Rosario',
		'Rosarivo' => 'Rosarivo',
		'Rouge Script' => 'Rouge Script',
		'Ruda' => 'Ruda',
		'Rufina' => 'Rufina',
		'Ruge Boogie' => 'Ruge Boogie',
		'Ruluko' => 'Ruluko',
		'Rum Raisin' => 'Rum Raisin',
		'Ruslan Display' => 'Ruslan Display',
		'Russo One' => 'Russo One',
		'Ruthie' => 'Ruthie',
		'Rye' => 'Rye',
		'Sacramento' => 'Sacramento',
		'Sail' => 'Sail',
		'Salsa' => 'Salsa',
		'Sanchez' => 'Sanchez',
		'Sancreek' => 'Sancreek',
		'Sansita One' => 'Sansita One',
		'Sarina' => 'Sarina',
		'Satisfy' => 'Satisfy',
		'Scada' => 'Scada',
		'Schoolbell' => 'Schoolbell',
		'Seaweed Script' => 'Seaweed Script',
		'Sevillana' => 'Sevillana',
		'Seymour One' => 'Seymour One',
		'Shadows Into Light' => 'Shadows Into Light',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shanti' => 'Shanti',
		'Share' => 'Share',
		'Share Tech' => 'Share Tech',
		'Share Tech Mono' => 'Share Tech Mono',
		'Shojumaru' => 'Shojumaru',
		'Short Stack' => 'Short Stack',
		'Sigmar One' => 'Sigmar One',
		'Signika' => 'Signika',
		'Signika Negative' => 'Signika Negative',
		'Simonetta' => 'Simonetta',
		'Sirin Stencil' => 'Sirin Stencil',
		'Six Caps' => 'Six Caps',
		'Skranji' => 'Skranji',
		'Slackey' => 'Slackey',
		'Smokum' => 'Smokum',
		'Smythe' => 'Smythe',
		'Sniglet' => 'Sniglet',
		'Snippet' => 'Snippet',
		'Snowburst One' => 'Snowburst One',
		'Sofadi One' => 'Sofadi One',
		'Sofia' => 'Sofia',
		'Sonsie One' => 'Sonsie One',
		'Sorts Mill Goudy' => 'Sorts Mill Goudy',
		'Sorts Mill Goudy' => 'Sorts Mill Goudy',
		'Source Code Pro' => 'Source Code Pro',
		'Source Sans Pro' => 'Source Sans Pro',
		'Special I am one' => 'Special I am one',
		'Spicy Rice' => 'Spicy Rice',
		'Spinnaker' => 'Spinnaker',
		'Spirax' => 'Spirax',
		'Squada One' => 'Squada One',
		'Stalemate' => 'Stalemate',
		'Stalinist One' => 'Stalinist One',
		'Stardos Stencil' => 'Stardos Stencil',
		'Stint Ultra Condensed' => 'Stint Ultra Condensed',
		'Stint Ultra Expanded' => 'Stint Ultra Expanded',
		'Stoke' => 'Stoke',
		'Stoke' => 'Stoke',
		'Strait' => 'Strait',
		'Sue Ellen Francisco' => 'Sue Ellen Francisco',
		'Sunshiney' => 'Sunshiney',
		'Supermercado One' => 'Supermercado One',
		'Swanky and Moo Moo' => 'Swanky and Moo Moo',
		'Syncopate' => 'Syncopate',
		'Tangerine' => 'Tangerine',
		'Telex' => 'Telex',
		'Tenor Sans' => 'Tenor Sans',
		'Terminal Dosis' => 'Terminal Dosis',
		'Terminal Dosis Light' => 'Terminal Dosis Light',
		'Text Me One' => 'Text Me One',
		'The Girl Next Door' => 'The Girl Next Door',
		'Tienne' => 'Tienne',
		'Tinos' => 'Tinos',
		'Titan One' => 'Titan One',
		'Titillium Web' => 'Titillium Web',
		'Trade Winds' => 'Trade Winds',
		'Trocchi' => 'Trocchi',
		'Trochut' => 'Trochut',
		'Trykker' => 'Trykker',
		'Tulpen One' => 'Tulpen One',
		'Ubuntu' => 'Ubuntu',
		'Ubuntu Condensed' => 'Ubuntu Condensed',
		'Ubuntu Mono' => 'Ubuntu Mono',
		'Ultra' => 'Ultra',
		'Uncial Antiqua' => 'Uncial Antiqua',
		'Underdog' => 'Underdog',
		'Unica One' => 'Unica One',
		'UnifrakturCook' => 'UnifrakturCook',
		'UnifrakturMaguntia' => 'UnifrakturMaguntia',
		'Unkempt' => 'Unkempt',
		'Unlock' => 'Unlock',
		'Unna' => 'Unna',
		'VT323' => 'VT323',
		'Vampiro One' => 'Vampiro One',
		'Varela' => 'Varela',
		'Varela Round' => 'Varela Round',
		'Vast Shadow' => 'Vast Shadow',
		'Vibur' => 'Vibur',
		'Vidaloka' => 'Vidaloka',
		'Viga' => 'Viga',
		'Voces' => 'Voces',
		'Volkhov' => 'Volkhov',
		'Vollkorn' => 'Vollkorn',
		'Voltaire' => 'Voltaire',
		'Waiting for the Sunrise' => 'Waiting for the Sunrise',
		'Wallpoet' => 'Wallpoet',
		'Walter Turncoat' => 'Walter Turncoat',
		'Warnes' => 'Warnes',
		'Wellfleet' => 'Wellfleet',
		'Wendy One' => 'Wendy One',
		'Wire One' => 'Wire One',
		'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
		'Yellowtail' => 'Yellowtail',
		'Yeseva One' => 'Yeseva One',
		'Yesteryear' => 'Yesteryear',
		'Zeyada' => 'Zeyada'
	);

	//array of all font sizes.
	$font_sizes = array( 
		'10px' => '10px',
		'11px' => '11px',
	);
	for($n=12;$n<=100;$n+=1){
		$font_sizes[$n.'px'] = $n.'px';
	}
	
	// Pull all the pages into an array
	 $options_pages = array();
	 $options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	 $options_pages[''] = 'Select a page:';
	 foreach ($options_pages_obj as $page) {
	  $options_pages[$page->ID] = $page->post_title;
	 }

	// array of section content.
	$section_text = array(
		1 => array(
			'section_title'		=> 'Our Classes',
			'menutitle'			=> '',
			'bgcolor' 			=> '#f8f9f9',
			'bgimage'			=> '',
			'class'				=> 'ourclasses',
			'content'			=> '[ourclasses show="4"]',
		),
		
		2 => array(
			'section_title'	=> 'Our Trainers',
			'menutitle'		=> '',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[ourteam show="4"]',
		),

		3 => array(
			'section_title'	=> 'Our Blog',
			'menutitle'		=> 'latestpost',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[latestposts show="3"]'
		),	
		
		4 => array(
			'section_title'	=> 'Testimonials',
			'menutitle'		=> 'testimonialsarea',
			'bgcolor' 		=> '',
			'bgimage'		=> '',
			'class'			=> 'testimonials-wrap',
			'content'		=> '[testimonials]',
		),		

		5 => array(
			'section_title'	=> '',
			'menutitle'		=> 'joinourclub',
			'bgcolor' 		=> '#8ee9f4',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> 'Join Our yogasana Club
			<h3>Vestibulum quam nunc, bibendum sed mauris vel, lacinia consectetur dolor</h3>
			<a href="#" class="signuonow">sign up now</a>
			',
		),			
	);

	$options = array();

	//Basic Settings
	$options[] = array(
		'name' => __('Basic Settings', 'skt-yogi'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Logo', 'skt-yogi'),
		'desc' => __('Upload your main logo here', 'skt-yogi'),
		'id' => 'logo',
		'class' => '',
		'std'	=> get_template_directory_uri()."/images/logo.png",
		'type' => 'upload');
		
	$options[] = array(	
		'desc' => __('Change your logo height', 'skt-yogi'),
		'id' => 'logoheight',
		'std' => '44',
		'type' => 'text');	

	$options[] = array(
		'name' => __('Custom CSS', 'skt-yogi'),
		'desc' => __('Some Custom Styling for your site. Place any css codes here instead of the style.css file.', 'skt-yogi'),
		'id' => 'style2',
		'std' => '',
		'type' => 'textarea');

	$options[] = array(
		'name' => __('Header Top Phone number and email', 'skt-yogi'),
		'desc' => __('Edit select social icons for header top', 'skt-yogi'),
		'id' => 'headersocial',
		'std' => ' <span class="phno"><i class="fa fa-phone"></i>+11 123 456 7890</span> <span><i class="fa fa-envelope"></i>
 info@sitename.com</span>',
		'type' => 'textarea');	
		
	$options[] = array(
		'name' => __('Header Top Info', 'skt-yogi'),
		'desc' => __('Edit header info from here.', 'skt-yogi'),
		'id' => 'headerinfo',
		'std' => ' <span>Week days: 05:00 - 22:00 </span> <span>Saturday: 08:00 - 18:00</span>  <span>Sunday: Closed</span> [searchform]',
		'type' => 'textarea');	
		
// font family start 
		
	$options[] = array(
		'name' => __('Font Faces', 'skt-yogi'),
		'desc' => __('Select font for the body text', 'skt-yogi'),
		'id' => 'bodyfontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the textual logo', 'skt-yogi'),
		'id' => 'logofontface',
		'type' => 'select',
		'std' => 'Playball',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the navigation text', 'skt-yogi'),
		'id' => 'navfontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for section heading text.', 'skt-yogi'),
		'id' => 'headfontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font family for header top bar', 'skt-yogi'),
		'id' => 'hdrtopfontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );	
		
	$options[] = array(
		'desc' => __('Select font face for the h1 heading', 'skt-yogi'),
		'id' => 'h1fontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );	
		
	$options[] = array(
		'desc' => __('Select font face for the h2 heading', 'skt-yogi'),
		'id' => 'h2fontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );	

	$options[] = array(
		'desc' => __('Select font face for the h3 heading', 'skt-yogi'),
		'id' => 'h3fontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );	

	$options[] = array(
		'desc' => __('Select font face for the h4 heading', 'skt-yogi'),
		'id' => 'h4fontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );	

	$options[] = array(
		'desc' => __('Select font face for the h5 heading', 'skt-yogi'),
		'id' => 'h5fontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );	

	$options[] = array(
		'desc' => __('Select font face for the h6 heading', 'skt-yogi'),
		'id' => 'h6fontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );	
		
// font sizes start	
	$options[] = array(
		'name' => __('Font Sizes', 'skt-yogi'),
		'desc' => __('Select font size for body text', 'skt-yogi'),
		'id' => 'bodyfontsize',
		'type' => 'select',
		'std' => '13px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for textual logo', 'skt-yogi'),
		'id' => 'logofontsize',
		'type' => 'select',
		'std' => '40px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for navigation', 'skt-yogi'),
		'id' => 'navfontsize',
		'type' => 'select',
		'std' => '13px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for section title', 'skt-yogi'),
		'id' => 'sectitlesize',
		'type' => 'select',
		'std' => '25px',
		'options' => $font_sizes );
	
	$options[] = array(
		'desc' => __('Select font size for footer title', 'skt-yogi'),
		'id' => 'ftfontsize',
		'type' => 'select',
		'std' => '20px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for header top bar', 'skt-yogi'),
		'id' => 'hdrtopfontsize',
		'type' => 'select',
		'std' => '13px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select h1 font size', 'skt-yogi'),
		'id' => 'h1fontsize',
		'std' => '36px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h2 font size', 'skt-yogi'),
		'id' => 'h2fontsize',
		'std' => '18px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h3 font size', 'skt-yogi'),
		'id' => 'h3fontsize',
		'std' => '20px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h4 font size', 'skt-yogi'),
		'id' => 'h4fontsize',
		'std' => '16px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h5 font size', 'skt-yogi'),
		'id' => 'h5fontsize',
		'std' => '14px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h6 font size', 'skt-yogi'),
		'id' => 'h6fontsize',
		'std' => '12px',
		'type' => 'select',
		'options' => $font_sizes);

	// font colors start
	$options[] = array(
		'name' => __('Font Colors', 'skt-yogi'),
		'desc' => __('Select font color for the body text', 'skt-yogi'),
		'id' => 'bodyfontcolor',
		'std' => '#78797c',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for textual logo', 'skt-yogi'),
		'id' => 'logofontcolor',
		'std' => '#2c2b2b',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for section title', 'skt-yogi'),
		'id' => 'sectitlecolor',
		'std' => '#5c5b5b',
		'type' => 'color');			

	$options[] = array(
		'desc' => __('Select font color for navigation', 'skt-yogi'),
		'id' => 'navfontcolor',
		'std' => '#444444',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for navigation hover', 'skt-yogi'),
		'id' => 'navhovercolor',
		'std' => '#55deef',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for home section 1 three column first title', 'skt-yogi'),
		'id' => 'colum1titlecolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for home section 1 three column second title', 'skt-yogi'),
		'id' => 'colum2titlecolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for home section 1 three column third title', 'skt-yogi'),
		'id' => 'colum3titlecolor',
		'std' => '#ffffff',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font color for home section 1 three column first description', 'skt-yogi'),
		'id' => 'columtextcolor1',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for home section 1 three column secon description', 'skt-yogi'),
		'id' => 'columtextcolor2',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for home section 1 three column third description', 'skt-yogi'),
		'id' => 'columtextcolor3',
		'std' => '#fffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for home section 1 three column read more', 'skt-yogi'),
		'id' => 'linkreadmore',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for home section Our Classes and trainer', 'skt-yogi'),
		'id' => 'classestrainerdescolor',
		'std' => '#a1a1a1',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for home section Our Classes and trainer hover', 'skt-yogi'),
		'id' => 'classestrainerdeshvcolor',
		'std' => '#ffffff',
		'type' => 'color');
				
		$options[] = array(
		'desc' => __('Select font color for home section Join Our yogasana Club', 'skt-yogi'),
		'id' => 'joinouryogasanaclub',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for widget title', 'skt-yogi'),
		'id' => 'wdgttitleccolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer title', 'skt-yogi'),
		'id' => 'foottitlecolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer', 'skt-yogi'),
		'id' => 'footdesccolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for footer menu ', 'skt-yogi'),
		'id' => 'footermenucolor',
		'std' => '#ffffff',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select hover/active font color for footer menu ', 'skt-yogi'),
		'id' => 'footermenucurrent',
		'std' => '#55deef',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font color for footer left text (copyright)', 'skt-yogi'),
		'id' => 'copycolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for links / anchor tags', 'skt-yogi'),
		'id' => 'linkcolor',
		'std' => '#55deef',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for links / anchor tags on hover', 'skt-yogi'),
		'id' => 'linkhovercolor',
		'std' => '#585757',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font color for sidebar li a', 'skt-yogi'),
		'id' => 'sidebarfontcolor',
		'std' => '#3b3b3b',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font hover color for sidebar li a', 'skt-yogi'),
		'id' => 'sidebarfonthvcolor',
		'std' => '#55deef',
		'type' => 'color');			
			
	$options[] = array(
		'desc' => __('Select font color for Testimonials title', 'skt-yogi'),
		'id' => 'tmn_titlefontcolor',
		'std' => '#3c3b3b',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for footer links', 'skt-yogi'),
		'id' => 'copylinks',
		'std' => '#55deef',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font hover color for footer links', 'skt-yogi'),
		'id' => 'copylinkshover',
		'std' => '#ffffff',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select font color for social icons', 'skt-yogi'),
		'id' => 'socialfontcolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select border hover color for social icons', 'skt-yogi'),
		'id' => 'socialfonthvcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select title color for footer posts', 'skt-yogi'),
		'id' => 'footerpoststitle',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select title hover color for footer posts', 'skt-yogi'),
		'id' => 'footerpoststitlehv',
		'std' => '#55deef',
		'type' => 'color');			
	
	$options[] = array(		
		'desc' => __('Select font color for header top bar', 'skt-yogi'),
		'id' => 'hdrtopfontcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select phone icon color for header top', 'skt-yogi'),
		'id' => 'phoneiconcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select font color for first section below the slider', 'skt-yogi'),
		'id' => 'fsh2color',
		'std' => '#000000',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h1 font color', 'skt-yogi'),
		'id' => 'h1fontcolor',
		'std' => '#585757',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select h2 font color', 'skt-yogi'),
		'id' => 'h2fontcolor',
		'std' => '#585757',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select h3 font color', 'skt-yogi'),
		'id' => 'h3fontcolor',
		'std' => '#585757',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select h4 font color', 'skt-yogi'),
		'id' => 'h4fontcolor',
		'std' => '#585757',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h5 font color', 'skt-yogi'),
		'id' => 'h5fontcolor',
		'std' => '#585757',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h6 font color', 'skt-yogi'),
		'id' => 'h6fontcolor',
		'std' => '#585757',
		'type' => 'color');	

	// Background start		
	$options[] = array(	
		'name' => __('Background Colors', 'skt-yogi'),	
		'desc' => __('Select background color for header', 'skt-yogi'),
		'id' => 'headerbg',
		'std' => '#ffffff',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select background color for section first column 1', 'skt-yogi'),
		'id' => 'columbgcolor1',
		'std' => '#55deef',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for section first column 2', 'skt-yogi'),
		'id' => 'columbgcolor2',
		'std' => '#29d6eb',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for section first column 3', 'skt-yogi'),
		'id' => 'columbgcolor3',
		'std' => '#0ccbe2',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for section first column 3 Read More button hover', 'skt-yogi'),
		'id' => 'linkreadmorebg',
		'std' => '#ffffff',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select border color for section first column 3 Read More button', 'skt-yogi'),
		'id' => 'linkreadmorebd',
		'std' => '#ffffff',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select background color for section Sign Up Now button', 'skt-yogi'),
		'id' => 'signupnowbgcolor',
		'std' => '#3d3d3d',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select background color hover for section Sign Up Now button', 'skt-yogi'),
		'id' => 'signupnowhvbgcolor',
		'std' => '#55deef',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select background color for section Our classes and trainers', 'skt-yogi'),
		'id' => 'classestrainerbgcolor',
		'std' => '#ffffff',
		'type' => 'color');		
	
	$options[] = array(
		'desc' => __('Select background color hover for section Our classes and trainers', 'skt-yogi'),
		'id' => 'classestrainerhvbgcolor',
		'std' => '#55deef',
		'type' => 'color');		
			
	$options[] = array(
		'desc' => __('Select border color for section Our classes and trainers', 'skt-yogi'),
		'id' => 'classestrainerbdcolor',
		'std' => '#55deef',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select background color for social icon', 'skt-yogi'),
		'id' => 'socialbgcolor',
		'std' => '#545556',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select background color for social icon', 'skt-yogi'),
		'id' => 'socialbghvcolor',
		'std' => '#55deef',
		'type' => 'color');				

	$options[] = array(
		'desc' => __('Select background color for footer', 'skt-yogi'),
		'id' => 'footerbgcolor',
		'std' => '#323232',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for copyright section', 'skt-yogi'),
		'id' => 'copybgcolor',
		'std' => '#292929',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for gallery hover', 'skt-yogi'),
		'id' => 'galhvcolor',
		'std' => '#55deef',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for sidebar widget', 'skt-yogi'),
		'id' => 'sidebarbgcolor',
		'std' => '#f9f9f9',
		'type' => 'color');	
		
	$options[] = array(	
		'desc' => __('Select background color for header top bar', 'skt-yogi'),
		'id' => 'hdrtopbgcolor',
		'std' => '#55deef',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for toggle menu', 'skt-yogi'),
		'id' => 'togglemenu',
		'std' => '#55deef',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for top search form', 'skt-yogi'),
		'id' => 'searchbgcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for testimonials description', 'skt-yogi'),
		'id' => 'tmndescbgcolor',
		'std' => '#f8f8f8',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for testimonials pagination', 'skt-yogi'),
		'id' => 'tmnpagerbg',
		'std' => '#464d51',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select border active color for testimonials pagination', 'skt-yogi'),
		'id' => 'tmnpagerbgactive',
		'std' => '#55deef',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background hover color for testimonials pagination', 'skt-yogi'),
		'id' => 'tmnpagerbghv',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for sidebar widget title', 'skt-yogi'),
		'id' => 'widgettitlebgcolor',
		'std' => '#55deef',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for toggle menu on responsive view', 'skt-yogi'),
		'id' => 'tgmenuresponsivebg',
		'std' => '#ffffff',
		'type' => 'color');																		

// Border colors
	$options[] = array(			
		'name' => __('Border Colors', 'skt-yogi'),		
		'desc' => __('Select border color for all section title', 'skt-yogi'),
		'id' => 'sectitlebdcolor',
		'std' => '#55deef',
		'type' => 'color');	
		
	$options[] = array(	
		'desc' => __('Select border color for inner pages title', 'skt-yogi'),
		'id' => 'pagestitlebdcolor',
		'std' => '#e8e8e8',
		'type' => 'color');			
		
	$options[] = array(	
		'desc' => __('Select border color for footer posts', 'skt-yogi'),
		'id' => 'footerpostborder',
		'std' => '#5e6162',
		'type' => 'color');	
		
	$options[] = array(			
		'desc' => __('Select border color for iframe', 'skt-yogi'),
		'id' => 'iframeborder',
		'std' => '#e5e5e4',
		'type' => 'color');	
		
	$options[] = array(			
		'desc' => __('Select border color for sidebar li a', 'skt-yogi'),
		'id' => 'sidebarliaborder',
		'std' => '#d0cfcf',
		'type' => 'color');		
		
	$options[] = array(			
		'desc' => __('Select border bottom color for section', 'skt-yogi'),
		'id' => 'secborderbottom',
		'std' => '#eaeaea',
		'type' => 'color');	
		
	$options[] = array(			
		'desc' => __('Select image border color for top our services', 'skt-yogi'),
		'id' => 'servicesimgborder',
		'std' => '#78e5f2',
		'type' => 'color');	
		
	// Default Buttons		
	$options[] = array(
		'name' => __('Button Colors', 'skt-yogi'),		
		'desc' => __('Select background color for button', 'skt-yogi'),
		'id' => 'btnbgcolor',
		'std' => '#323232',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select hover background color for button', 'skt-yogi'),
		'id' => 'btnbghvcolor',
		'std' => '#55deef',
		'type' => 'color');		

	$options[] = array(
		'desc' => __('Select font color button', 'skt-yogi'),
		'id' => 'btntxtcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color button on hover', 'skt-yogi'),
		'id' => 'btntxthvcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select border color button', 'skt-yogi'),
		'id' => 'btnbordercolor',
		'std' => '#292929',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select button border color on hover', 'skt-yogi'),
		'id' => 'btnborderhvcolor',
		'std' => '#1898c2',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select transparent button border color', 'skt-yogi'),
		'id' => 'tbbtnborder',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select transparent button border color on hover', 'skt-yogi'),
		'id' => 'tbbtnhvborder',
		'std' => '#ff6565',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select transparent button font color', 'skt-yogi'),
		'id' => 'tbfontcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select transparent button font color on hover', 'skt-yogi'),
		'id' => 'tbfonthvcolor',
		'std' => '#ff6565',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select active border bottom color for filter gallery', 'skt-yogi'),
		'id' => 'galleryactivebc',
		'std' => '#55deef',
		'type' => 'color');			

	// Slider Caption colors
	$options[] = array(	
		'name' => __('Slider Caption Title', 'skt-yogi'),			
		'desc' => __('Select font color for slider title', 'skt-yogi'),
		'id' => 'slidetitlecolor',
		'std' => '#ffffff',
		'type' => 'color');	

	$options[] = array(		
		'desc' => __('Select Background color for slider title', 'skt-yogi'),
		'id' => 'slidetitlebgcolor',
		'std' => '#55deef',
		'type' => 'color');		

	$options[] = array(
		'desc' => __('Select font for the slide title', 'skt-yogi'),
		'id' => 'slidetitlefontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font size for slider title', 'skt-yogi'),
		'id' => 'slidetitlefontsize',
		'type' => 'select',
		'std' => '38px',
		'options' => $font_sizes );
		
	$options[] = array(		
		'name' => __('Slider Caption Description', 'skt-yogi'),			
		'desc' => __('Select font color for slider description', 'skt-yogi'),
		'id' => 'slidedesccolor',
		'std' => '#ffffff',
		'type' => 'color');	
	
	$options[] = array(		
		'desc' => __('Select Background color for slide description ', 'skt-yogi'),
		'id' => 'slidedescbgcolor',
		'std' => '#000000',
		'type' => 'color');		
		
	$options[] = array(		
		'desc' => __('Select opacity for slider description background', 'skt-yogi'),
		'id' => 'descbgopacity',
		'std' => '0.6',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));		
		
	$options[] = array(
		'desc' => __('Select font size for slider description', 'skt-yogi'),
		'id' => 'slidedescfontsize',
		'type' => 'select',
		'std' => '13px',
		'options' => $font_sizes );

	$options[] = array(
		'desc' => __('Select font for the slide description', 'skt-yogi'),
		'id' => 'slidedescfontface',
		'type' => 'select',
		'std' => 'Open Sans',
		'options' => $font_types );

	$options[] = array(	
		'desc' => __('Select font style for slide description italic text', 'skt-yogi'),
		'id' => 'descfontstyle',
		'std' => 'italic',
		'type' => 'select',		
		'options' => array('italic' => 'italic','normal' => 'normal'));
		
	$options[] = array(		
		'name' => __('Slider Caption Read More Button', 'skt-yogi'),			
		'desc' => __('Select font color for slider button', 'skt-yogi'),
		'id' => 'slidebtntxtcolor',
		'std' => '#55ddef',
		'type' => 'color');	

	$options[] = array(		
		'desc' => __('Select Background color for slider button ', 'skt-yogi'),
		'id' => 'slidebtnbgcolor',
		'std' => '',
		'type' => 'color');		
			
	$options[] = array(		
		'desc' => __('Select border color for slider button ', 'skt-yogi'),
		'id' => 'slidebtnbordercolor',
		'std' => '#55ddef',
		'type' => 'color');			
		
	// Slider controls colors		
	$options[] = array(
		'name' => __('Slider controls Colors', 'skt-yogi'),
		'desc' => __('Select background color for slider pager', 'skt-yogi'),
		'id' => 'sldpagebg',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for slider pager active', 'skt-yogi'),
		'id' => 'sldpagehvbg',
		'std' => '#55ddef',
		'type' => 'color');	
		
	$options[] = array(
		'name' => __('Custom Excerpt Length', 'skt-yogi'),	
		'desc' => __('Select excerpt length for top three column services boxes', 'skt-yogi'),
		'id' => 'servicesbxexcerptlength',
		'std' => '22',
		'type' => 'text');
		
	$options[] = array(	
		'desc' => __('Select excerpt length for our classes boxes', 'skt-yogi'),
		'id' => 'classesboxexcerptlength',
		'std' => '23',
		'type' => 'text');
		
	$options[] = array(	
		'desc' => __('Select excerpt length for homepage blog posts', 'skt-yogi'),
		'id' => 'hmblogpostsexcerptlength',
		'std' => '35',
		'type' => 'text');	
		
	$options[] = array(	
		'desc' => __('Select excerpt length for testimonials', 'skt-yogi'),
		'id' => 'testimonialsexcerptlenth',
		'std' => '60',
		'type' => 'text');	
		
	$options[] = array(	
		'desc' => __('Select excerpt length for footer latest posts', 'skt-yogi'),
		'id' => 'footerpostlength',
		'std' => '8',
		'type' => 'text');	
		
	$options[] = array(	
		'desc' => __('Select excerpt length for blog posts templates', 'skt-yogi'),
		'id' => 'blogtemexcerptlength',
		'std' => '70',
		'type' => 'text');			
		
	$options[] = array(
		'name' => __('Read More Button Text Manageable', 'skt-yogi'),	
		'desc' => __('Change read more button text for our classes boxes', 'skt-yogi'),
		'id' => 'classbxreadmore',
		'std' => 'Read More',
		'type' => 'text');
		
	$options[] = array(	
		'desc' => __('Change more info button text for homepage blog posts', 'skt-yogi'),
		'id' => 'latestpostsmoreinfo',
		'std' => 'More Info',
		'type' => 'text');	
		
	$options[] = array(	
		'desc' => __('Change read more button text for blog posts templates', 'skt-yogi'),
		'id' => 'blogreadmoretext',
		'std' => 'Read More >',
		'type' => 'text');				
		
	$options[] = array(
		'name' => __('Blog Single Layout', 'skt-yogi'),
		'desc' => __('Select Blog Sidebar layout. eg: Left Sidebar, Right Sidebar, No Sidebar, Full WIdth Sidebar', 'skt-yogi'),
		'id' => 'singlelayout',
		'type' => 'select',
		'std' => 'singleright',
		'options' => array('singleright'=>'Blog Single Right Sidebar', 'singleleft'=>'Blog Single Left Sidebar', 'sitefull'=>'Blog Single Full Width', 'nosidebar'=>'Blog Single No Sidebar') );
		
	$options[] = array(
		'name' => __('Woocommerce Page Layout', 'skt-yogi'),
		'desc' => __('Select layout. eg:right-sidebar, left-sidebar, full-width', 'skt-yogi'),
		'id' => 'woocommercelayout',
		'type' => 'select',
		'std' => 'woocommercesitefull',
		'options' => array('woocommerceright'=>'Woocommerce Right Sidebar', 'woocommerceleft'=>'Woocommerce Left Sidebar', 'woocommercesitefull'=>'Woocommerce Full Width') );		
		
	$options[] = array(
		'name' => __('Social Icon Style', 'skt-yogi'),
		'desc' => __('Select Style. eg:circle, square', 'skt-yogi'),
		'id' => 'socialstyle',		
		'std' => '50',
		'type' => 'select',
		'options' => array('50'=>'Social icons Style in Circle', '0'=>'Social icons Style in Square') );
		
	$options[] = array(
		'name' => __('Responsive View Menu word changeable', 'skt-yogi'),
		'desc' => __('Change menu word on responsive view', 'skt-yogi'),
		'id' => 'menuwordchange',
		'std' => 'Menu',
		'type' => 'text');					

	//Layout Settings
	$options[] = array(
		'name' => __('Sections', 'skt-yogi'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Top Three Column Services Boxes','skt-yogi'),
		'desc'	=> __('First Services box for frontpage section','skt-yogi'),
		'id' 	=> 'box1',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image  for first box.', 'skt-yogi'),
		'id' => 'boximg1',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Second Services box for frontpage section','skt-yogi'),
		'id' 	=> 'box2',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image  for second box.', 'skt-yogi'),
		'id' => 'boximg2',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Third Services box for frontpage section','skt-yogi'),
		'id' 	=> 'box3',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image  for third box.', 'skt-yogi'),
		'id' => 'boximg3',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Fourth Services box for frontpage section','skt-yogi'),
		'id' 	=> 'box4',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image  for fourth box.', 'skt-yogi'),
		'id' => 'boximg4',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Fifth Services box for frontpage section','skt-yogi'),
		'id' 	=> 'box5',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image  for fifth box.', 'skt-yogi'),
		'id' => 'boximg5',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Six Services box for frontpage section','skt-yogi'),
		'id' 	=> 'box6',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image  for six box.', 'skt-yogi'),
		'id' => 'boximg6',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');		
	
	$options[] = array(
		'desc' => __('Read More Button Text for Pages', 'skt-yogi'),
		'id' => 'threecolreadmorebutton',
		'std' => 'Read More',
		'type' => 'text');
	
	$options[] = array(			
			'desc'	=> __('Check to hide above three column services section', 'skt-yogi'),
			'id'	=> 'hidethreebxsec',
			'type'	=> 'checkbox',
			'std'	=> '');

	$options[] = array(
		'name' => __('Welcome Page for Section 2','skt-yogi'),
		'desc'	=> __('select welcome page for frontpage section First','skt-yogi'),
		'id' 	=> 'welcomepage',
		'type'	=> 'select',
		'options' => $options_pages,
	);	
	
	$options[] = array(		
		'desc' => __('upload image welcome section', 'skt-yogi'),
		'id' => 'welcomeimg',		
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(		
		'desc' => __('Change more info button text for welcome to yogasana section', 'skt-yogi'),
		'id' => 'welcomemoreinfo',
		'std' => 'More Info',
		'type' => 'text');	
		
	$options[] = array(			
			'desc'	=> __('Check to hide welcome to yogasana section', 'skt-yogi'),
			'id'	=> 'hidewelcomesec',
			'type'	=> 'checkbox',
			'std'	=> '');			

	$options[] = array(
		'name' => __('Number of Sections', 'skt-yogi'),
		'desc' => __('Select number of sections', 'skt-yogi'),
		'id' => 'numsection',
		'type' => 'select',
		'std' => '5',
		'options' => array_combine(range(1,30), range(1,30)) );

	$numsecs = of_get_option( 'numsection', 5 );

	for( $n=1; $n<=$numsecs; $n++){
		$options[] = array(
			'desc' => __("<h3>Section ".$n."</h3>", 'skt-yogi'),
			'class' => 'toggle_title',
			'type' => 'info');	
	
		$options[] = array(
			'name' => __('Section Title', 'skt-yogi'),
			'id' => 'sectiontitle'.$n,
			'std' => ( ( isset($section_text[$n]['section_title']) ) ? $section_text[$n]['section_title'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section ID', 'skt-yogi'),
			'desc'	=> __('Enter your section ID here. SECTION ID MUST BE IN SMALL LETTERS ONLY AND DO NOT ADD SPACE OR SYMBOL.'),
			'id' => 'menutitle'.$n,
			'std' => ( ( isset($section_text[$n]['menutitle']) ) ? $section_text[$n]['menutitle'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section Background Color', 'skt-yogi'),
			'desc' => __('Select background color for section', 'skt-yogi'),
			'id' => 'sectionbgcolor'.$n,
			'std' => ( ( isset($section_text[$n]['bgcolor']) ) ? $section_text[$n]['bgcolor'] : '' ),
			'type' => 'color');
			
		$options[] = array(
			'name' => __('Background Image', 'skt-yogi'),
			'id' => 'sectionbgimage'.$n,
			'class' => '',
			'std' => ( ( isset($section_text[$n]['bgimage']) ) ? $section_text[$n]['bgimage'] : '' ),
			'type' => 'upload');

		$options[] = array(
			'name' => __('Section CSS Class', 'skt-yogi'),
			'desc' => __('Set class for this section.', 'skt-yogi'),
			'id' => 'sectionclass'.$n,
			'std' => ( ( isset($section_text[$n]['class']) ) ? $section_text[$n]['class'] : '' ),
			'type' => 'text');
			
		$options[] = array(
			'name'	=> __('Hide Section', 'skt-yogi'),
			'desc'	=> __('Check to hide this section', 'skt-yogi'),
			'id'	=> 'hidesec'.$n,
			'type'	=> 'checkbox',
			'std'	=> '');

		$options[] = array(
			'name' => __('Section Content', 'skt-yogi'),
			'id' => 'sectioncontent'.$n,
			'std' => ( ( isset($section_text[$n]['content']) ) ? $section_text[$n]['content'] : '' ),
			'type' => 'editor');
	}

	//SLIDER SETTINGS
	$options[] = array(
		'name' => __('Homepage Slider', 'skt-yogi'),
		'type' => 'heading');
		
		
	$options[] = array(
		'name' => __('Inner Page Banner', 'skt-yogi'),
		'desc' => __('Upload inner page banner for site', 'skt-yogi'),
		'id' => 'innerpagebanner',
		'class' => '',
		'std'	=> get_template_directory_uri()."/images/default-banner.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('Custom Slider Shortcode Area For Home Page', 'skt-yogi'),
		'desc' => __('Enter here your slider shortcode without php tag', 'skt-yogi'),
		'id' => 'customslider',
		'std' => '',
		'type' => 'textarea');			
		
	$options[] = array(
		'name' => __('Slider Effects and Timing', 'skt-yogi'),
		'desc' => __('Select slider effect.','skt-yogi'),
		'id' => 'slideefect',
		'std' => 'fade',
		'type' => 'select',
		'options' => array('random'=>'Random', 'fade'=>'Fade', 'fold'=>'Fold', 'sliceDown'=>'Slide Down', 'sliceDownLeft'=>'Slide Down Left', 'sliceUp'=>'Slice Up', 'sliceUpLeft'=>'Slice Up Left', 'sliceUpDown'=>'Slice Up Down', 'sliceUpDownLeft'=>'Slice Up Down Left', 'slideInRight'=>'SlideIn Right', 'slideInLeft'=>'SlideIn Left', 'boxRandom'=>'Box Random', 'boxRain'=>'Box Rain', 'boxRainReverse'=>'Box Rain Reverse', 'boxRainGrow'=>'Box Rain Grow', 'boxRainGrowReverse'=>'Box Rain Grow Reverse' ));
		
	$options[] = array(
		'desc' => __('Animation speed should be multiple of 100.', 'skt-yogi'),
		'id' => 'slideanim',
		'std' => 500,
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add slide pause time.', 'skt-yogi'),
		'id' => 'slidepause',
		'std' => 4000,
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slide Controllers', 'skt-yogi'),
		'desc' => __('Hide/Show Direction Naviagtion of slider.','skt-yogi'),
		'id' => 'slidenav',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Hide/Show pager of slider.','skt-yogi'),
		'id' => 'slidepage',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Pause Slide on Hover.','skt-yogi'),
		'id' => 'slidepausehover',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Yes', 'false'=>'No'));
		
	$options[] = array(
		'name' => __('Slider Image 1', 'skt-yogi'),
		'desc' => __('First Slide', 'skt-yogi'),
		'id' => 'slide1',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider1.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 1', 'skt-yogi'),
		'id' => 'slidetitle1',
		'std' => 'Fight Stress & Find Serenity',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc1',
		'std' => 'Suspendisse potenti. Sed nec posuere nulla. Vestibulum et sagittis sem. Aenean lorem nibh, varius vel tellus sit amet, dapibus fermentum urna. Proin venenatis in metus a varius. Phasellus scelerisque tincidunt elit, quis mollis odio aliquam ac. Etiam vehicula porta ligula, at tincidunt lectus venenatis sed. Phasellus eu est est. Donec ut iaculis ante. Nullam a viverra leo. Cras a purus ut enim molestie luctus.',
		'type' => 'textarea');

	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton1',
		'std' => 'Read More',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl1',
		'std' => '#',
		'type' => 'text');		

	
	$options[] = array(
		'name' => __('Slider Image 2', 'skt-yogi'),
		'desc' => __('Second Slide', 'skt-yogi'),
		'class' => '',
		'id' => 'slide2',
		'std' => get_template_directory_uri()."/images/slides/slider2.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 2', 'skt-yogi'),
		'id' => 'slidetitle2',
		'std' => 'Reduce Fat & Increase Energy',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc2',
		'std' => 'Suspendisse potenti. Sed nec posuere nulla. Vestibulum et sagittis sem. Aenean lorem nibh, varius vel tellus sit amet, dapibus fermentum urna. Proin venenatis in metus a varius. Phasellus scelerisque tincidunt elit, quis mollis odio aliquam ac. Etiam vehicula porta ligula, at tincidunt lectus venenatis sed. Phasellus eu est est. Donec ut iaculis ante. Nullam a viverra leo. Cras a purus ut enim molestie luctus.',
		'type' => 'textarea');		
		
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton2',
		'std' => 'Read More',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl2',
		'std' => '#',
		'type' => 'text');		
	
	$options[] = array(
		'name' => __('Slider Image 3', 'skt-yogi'),
		'desc' => __('Third Slide', 'skt-yogi'),
		'id' => 'slide3',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider3.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 3', 'skt-yogi'),
		'id' => 'slidetitle3',
		'std' => 'Find Inner Peace & Greater Flexibility',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc3',
		'std' => 'Suspendisse potenti. Sed nec posuere nulla. Vestibulum et sagittis sem. Aenean lorem nibh, varius vel tellus sit amet, dapibus fermentum urna. Proin venenatis in metus a varius. Phasellus scelerisque tincidunt elit, quis mollis odio aliquam ac. Etiam vehicula porta ligula, at tincidunt lectus venenatis sed. Phasellus eu est est. Donec ut iaculis ante. Nullam a viverra leo. Cras a purus ut enim molestie luctus.',
		'type' => 'textarea');	
	
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton3',
		'std' => 'Read More',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl3',
		'std' => '#',
		'type' => 'text');		
			
	
	$options[] = array(
		'name' => __('Slider Image 4', 'skt-yogi'),
		'desc' => __('Fourth Slide', 'skt-yogi'),
		'id' => 'slide4',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider4.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 4', 'skt-yogi'),
		'id' => 'slidetitle4',
		'std' => 'Boost Immunity & Detoxify your body',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc4',
		'std' => 'Suspendisse potenti. Sed nec posuere nulla. Vestibulum et sagittis sem. Aenean lorem nibh, varius vel tellus sit amet, dapibus fermentum urna. Proin venenatis in metus a varius. Phasellus scelerisque tincidunt elit, quis mollis odio aliquam ac. Etiam vehicula porta ligula, at tincidunt lectus venenatis sed. Phasellus eu est est. Donec ut iaculis ante. Nullam a viverra leo. Cras a purus ut enim molestie luctus.',
		'type' => 'textarea');	
		
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton4',
		'std' => 'Read More',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl4',
		'std' => '#',
		'type' => 'text');		
	
	$options[] = array(
		'name' => __('Slider Image 5', 'skt-yogi'),
		'desc' => __('Fifth Slide', 'skt-yogi'),
		'id' => 'slide5',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 5', 'skt-yogi'),
		'id' => 'slidetitle5',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc5',
		'std' => '',
		'type' => 'textarea');	
		
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton5',
		'std' => '',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl5',
		'std' => '',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Slider Image 6', 'skt-yogi'),
		'desc' => __('Sixth Slide', 'skt-yogi'),
		'id' => 'slide6',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 6', 'skt-yogi'),
		'id' => 'slidetitle6',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc6',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton6',
		'std' => '',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl6',
		'std' => '',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Slider Image 7', 'skt-yogi'),
		'desc' => __('Seventh Slide', 'skt-yogi'),
		'id' => 'slide7',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 7', 'skt-yogi'),
		'id' => 'slidetitle7',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc7',
		'std' => '',
		'type' => 'textarea');

	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton7',
		'std' => '',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl7',
		'std' => '',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Slider Image 8', 'skt-yogi'),
		'desc' => __('Eighth Slide', 'skt-yogi'),
		'id' => 'slide8',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 8', 'skt-yogi'),
		'id' => 'slidetitle8',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc8',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton8',
		'std' => '',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl8',
		'std' => '',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Slider Image 9', 'skt-yogi'),
		'desc' => __('Ninth Slide', 'skt-yogi'),
		'id' => 'slide9',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 9', 'skt-yogi'),
		'id' => 'slidetitle9',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc9',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton9',
		'std' => '',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl9',
		'std' => '',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Slider Image 10', 'skt-yogi'),
		'desc' => __('Tenth Slide', 'skt-yogi'),
		'id' => 'slide10',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 10', 'skt-yogi'),
		'id' => 'slidetitle10',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-yogi'),
		'id' => 'slidedesc10',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Slide Button Text', 'skt-yogi'),
		'id' => 'slidebutton10',
		'std' => '',
		'type' => 'text');		
	
	$options[] = array(
		'desc' => __('Slide Button Url', 'skt-yogi'),
		'id' => 'slideurl10',
		'std' => '',
		'type' => 'text');	

	//Footer SETTINGS
	$options[] = array(
		'name' => __('Footer', 'skt-yogi'),
		'type' => 'heading');
				
	$options[] = array(
		'name' => __('Footer About Us', 'skt-yogi'),
		'desc' => __('about Us text title for footer', 'skt-yogi'),
		'id' => 'aboutustitle',
		'std' => 'About Us',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('About Us Description', 'skt-yogi'),
		'desc' => __('about Us text description for footer', 'skt-yogi'),
		'id' => 'aboutdescription',
		'std' => '<p>Sed suscipit mauris nec mauris vulputate, a posuere libero congue. Nam laoreet elit eu erat pulvinar, et efficitur nibh euismod. Proin venenatis orci sit amet nisl finibus vehicula. </p>

<p>Nam metus lorem, hendrerit quis ante eget, lobortis elementum neque. Aliquam in ullamcorper quam. Integer euismod ligula in mauris vehicula imperdiet. Cras in convallis ipsum. Phasellus</p> ',
		'type' => 'textarea');

	$options[] = array(
		'desc' => __('add social icon name and link in the shortcodes.  NOTE: Icon name should be in lowercase without space.(exa.phone) More social icons can be found at: http://fortawesome.github.io/Font-Awesome/icons/', 'skt-yogi'),
		'id' => 'footersocialicons',
		'std' => '[social_area]
    [social icon="facebook" link="#"]
    [social icon="twitter" link="#"]
    [social icon="linkedin" link="#"]
    [social icon="pinterest" link="#"]
    [social icon="google-plus" link="#"]
	[social icon="youtube" link="#"]	
[/social_area]',
		'type' => 'textarea');		

		
	$options[] = array(
		'name' => __('Latest Tweets', 'skt-yogi'),
		'desc' => __('Footer latest tweets title.', 'skt-yogi'),
		'id' => 'usefullinktitle',
		'std' => 'Latest Tweets',
		'type' => 'text');	

	$options[] = array(
		'name' => __(' Latest Posts Title', 'skt-yogi'),
		'desc' => __('latest posts title for footer.', 'skt-yogi'),
		'id' => 'frptitle',
		'std' => 'Latest Posts',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Footer Address Title', 'skt-yogi'),
		'desc' => __('Add contact title here', 'skt-yogi'),
		'id' => 'contacttitle',
		'std' => 'Contact Info',
		'type' => 'text');	
		
	$options[] = array(	
		'desc' => __('Add company address1 here.', 'skt-yogi'),
		'id' => 'address',
		'std' => '123 Bridge Street,',
		'type' => 'text');
		
	$options[] = array(	
		'desc' => __('Add company address2 here.', 'skt-yogi'),
		'id' => 'address2',
		'std' => 'New York, NY 666555',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Add phone number here.', 'skt-yogi'),
		'id' => 'phone',
		'std' => '1.800.555.6789',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add email address here.', 'skt-yogi'),
		'id' => 'email',
		'std' => 'support@sitename.com',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add company url here with http://.', 'skt-yogi'),
		'id' => 'weblink',
		'std' => 'http://sktthemes.net',
		'type' => 'text');
		
		$options[] = array(
		'name' => __('Google Map', 'skt-yogi'),
		'desc' => __('Use iframe code url here. DO NOT APPLY IFRAME TAG', 'skt-exceptiona'),
		'id' => 'googlemap',
		'std' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d336003.6066860609!2d2.349634820486094!3d48.8576730786213!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e66e1f06e2b70f%3A0x040b82c3688c9460!2sParis%2C+France!5e0!3m2!1sen!2sin!4v1433482358672',
		'type' => 'textarea');
			
	$options[] = array(
		'name' => __('Footer Copyright', 'skt-yogi'),
		'desc' => __('Copyright Text for your site.', 'skt-yogi'),
		'id' => 'copytext',
		'std' => '&copy; Copyright 2015 <a href="#">SKT Yogi. </a> | All Rights Reserved |',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Footre Text Link', 'skt-yogi'),
		'id' => 'ftlink',
		'std' => 'Design by <a href="'.esc_url('http://www.sktthemes.net/').'" target="_blank">SKT Themes</a>',
		'type' => 'textarea',);

	//Short codes
	$options[] = array(
		'name' => __('Short Codes', 'skt-yogi'),
		'type' => 'heading');	
		
	
	$options[] = array(
		'name' => __('Photo Gallery', 'skt-yogi'),
		'desc' => __('[photogallery filter="true"]', 'skt-yogi'),
		'type' => 'info');			
			
		
	$options[] = array(
		'name' => __('Testimonials', 'skt-yogi'),
		'desc' => __('[testimonials]', 'skt-yogi'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Contact Form', 'skt-yogi'),
		'desc' => __('[contactform to_email="test@example.com" title="Contact Form"] 
', 'skt-yogi'),
		'type' => 'info');		
		
	$options[] = array(
		'name' => __('Footer posts', 'skt-yogi'),
		'desc' => __('[footer-posts show="2"]', 'skt-yogi'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Team Member and Our Trainers', 'skt-yogi'),
		'desc' => __('[ourteam show="4"]', 'skt-yogi'),
		'type' => 'info');					
	
		$options[] = array(
		'name' => __('Our Classes', 'skt-yogi'),
		'desc' => __('[ourclasses show="4"]', 'skt-yogi'),
		'type' => 'info');					
	
				
	$options[] = array(
		'name' => __('Search Form', 'skt-yogi'),
		'desc' => __('[searchform] 
', 'skt-yogi'),
		'type' => 'info');
			
		
	$options[] = array(
		'name' => __('Headings', 'skt-yogi'),
		'desc' => __('[heading underline="yes" align="left"]Our Team[/heading]', 'skt-yogi'),
		'type' => 'info');	

		
	$options[] = array(
		'name' => __('Social Icons ( Note: More social icons can be found at: http://fortawesome.github.io/Font-Awesome/icons/)', 'skt-yogi'),
		'desc' => __('[social_area]
    [social icon="facebook" link="#"]
    [social icon="twitter" link="#"]
    [social icon="linkedin" link="#"]
    [social icon="pinterest" link="#"]
    [social icon="google-plus" link="#"]
	[social icon="youtube" link="#"]
	[social icon="wordpress" link="#"]
	[social icon="flickr" link="#"]
	[social icon="skype" link="#"]
[/social_area]', 'skt-yogi'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('Animation Name list', 'skt-yogi'),
		'desc' => __('bounce, flash, pulse, shake, swing, tada, wobble, bounceIn, bounceInDown, bounceInLeft, bounceInRight, bounceInUp, bounceOut, bounceOutDown, bounceOutLeft, bounceOutRight, bounceOutUp, fadeIn, fadeInDown, fadeInDownBig, fadeInLeft, fadeInLeftBig, fadeInRight, fadeInRightBig, fadeInUp, fadeInUpBig, fadeOut, fadeOutDown, fadeOutDownBig, fadeOutLeft, fadeOutLeftBig, fadeOutRight, fadeOutRightBig, fadeOutUp, fadeOutUpBig, flip, flipInX, flipInY, flipOutX, flipOutY, lightSpeedIn, lightSpeedOut, rotateIn, rotateInDownLeft, rotateInDownRight, rotateInUpLeft, rotateInUpRight, rotateOut, rotateOutDownLeft, rotateOutDownRight, rotateOutUpLeft, rotateOutUpRight, slideInDown, slideInLeft, slideInRight, slideOutLeft, slideOutRight, slideOutUp, rollIn, rollOut, zoomIn, zoomInDown, zoomInLeft, zoomInRight, zoomInUp', 'skt-yogi'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('2 Column Content', 'skt-yogi'),
		'desc' => __('<pre>
[column_content type="one_half" animation="name of animation"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_half_last" animation="name of animation"]
	Column 2 Content goes here...
[/column_content]
</pre>', 'skt-yogi'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('3 Column Content', 'skt-yogi'),
		'desc' => __('<pre>
[column_content type="one_third" animation="name of animation"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_third" animation="name of animation"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_third_last" animation="name of animation"]
	Column 3 Content goes here...
[/column_content]
</pre>', 'skt-yogi'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('4 Column Content', 'skt-yogi'),
		'desc' => __('<pre>
[column_content type="one_fourth" animation="name of animation"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fourth" animation="name of animation"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fourth" animation="name of animation"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fourth_last" animation="name of animation"]
	Column 4 Content goes here...
[/column_content]
</pre>', 'skt-yogi'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('5 Column Content', 'skt-yogi'),
		'desc' => __('<pre>
[column_content type="one_fifth" animation="name of animation"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fifth" animation="name of animation"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fifth" animation="name of animation"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fifth" animation="name of animation"]
	Column 4 Content goes here...
[/column_content]

[column_content type="one_fifth_last" animation="name of animation"]
	Column 5 Content goes here...
[/column_content]
</pre>', 'skt-yogi'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('Clear', 'skt-yogi'),
		'desc' => __('<pre>
[clear]
</pre>', 'skt-yogi'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('HR / Horizontal separation line', 'skt-yogi'),
		'desc' => __('<pre>
[hr] or &lt;hr&gt;
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Separator / blank space', 'skt-yogi'),
		'desc' => __('<pre>
[separator height="20"]
</pre>', 'skt-yogi'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Blank space without image', 'skt-yogi'),
		'desc' => __('<pre>
[blankspace height="20"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Tabs', 'skt-yogi'),
		'desc' => __('<pre>
[tabs]
	[tab title="TAB TITLE 1"]
		TAB CONTENT 1
	[/tab]
	[tab title="TAB TITLE 2"]
		TAB CONTENT 2
	[/tab]
	[tab title="TAB TITLE 3"]
		TAB CONTENT 3
	[/tab]
[/tabs]
</pre>', 'skt-yogi'),
		'type' => 'info');


	$options[] = array(
		'name' => __('Toggle Content', 'skt-yogi'),
		'desc' => __('<pre>
[toggle_content title="Toggle Title 1"]
	Toggle content 1...
[/toggle_content]
[toggle_content title="Toggle Title 2"]
	Toggle content 2...
[/toggle_content]
[toggle_content title="Toggle Title 3"]
	Toggle content 3...
[/toggle_content]
</pre>', 'skt-yogi'),
		'type' => 'info');


	$options[] = array(
		'name' => __('Accordion Content', 'skt-yogi'),
		'desc' => __('<pre>
[accordion]
	[accordion_content title="ACCORDION TITLE 1"]
		ACCORDION CONTENT 1
	[/accordion_content]
	[accordion_content title="ACCORDION TITLE 2"]
		ACCORDION CONTENT 2
	[/accordion_content]
	[accordion_content title="ACCORDION TITLE 3"]
		ACCORDION CONTENT 3
	[/accordion_content]
[/accordion]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Gradient Button - Small', 'skt-yogi'),
		'desc' => __('<pre>
[gradient_button size="small" bg_color="#e00" color="#fff" text="Medium Gradient Button" title="Medium Gradient Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Gradient Button - Medium', 'skt-yogi'),
		'desc' => __('<pre>
[gradient_button size="medium" bg_color="#060" color="#fff" text="Medium Gradient Button" title="Medium Gradient Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Gradient Button - Large', 'skt-yogi'),
		'desc' => __('<pre>
[gradient_button size="large" bg_color="#026" color="#fff" text="Large Gradient Button" title="Large Gradient Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Gradient Button - Xtra Large', 'skt-yogi'),
		'desc' => __('<pre>
[gradient_button size="x-large" bg_color="#00ccff" color="#fff" text="Extra Large Simple Button" title="Extra Large Simple Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Small', 'skt-yogi'),
		'desc' => __('<pre>
[simple_button size="small" bg_color="#c00" color="#fff" text="Small Simple Button" title="Small Simple Button" url="#" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Medium', 'skt-yogi'),
		'desc' => __('<pre>
[simple_button size="medium" bg_color="#060" color="#fff" text="Medium Simple Button" title="Medium Simple Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Large', 'skt-yogi'),
		'desc' => __('<pre>
[simple_button size="large" bg_color="#026" color="#fff" text="Large Simple Button" title="Large Simple Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Xtra Large', 'skt-yogi'),
		'desc' => __('<pre>
[simple_button size="x-large" bg_color="#00ccff" color="#fff" text="Extra Large Simple Button" title="Extra Large Simple Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Round Button - Light', 'skt-yogi'),
		'desc' => __('<pre>
[round_button style="light" text="Round Button" title="Round Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Round Button - Dark', 'skt-yogi'),
		'desc' => __('<pre>
[round_button style="dark" text="Round Button" title="Round Button" url="" position="left"]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Message Box - Success', 'skt-yogi'),
		'desc' => __('<pre>
[message type="success"]This is a sample of the \'success\' style message box shortcode. To use this style use the following shortcode[/message]
</pre>', 'skt-yogi'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - Error', 'skt-yogi'),
		'desc' => __('<pre>
[message type="error"]This is a sample of the \'error\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-yogi'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - Warning', 'skt-yogi'),
		'desc' => __('<pre>
[message type="warning"]This is a sample of the \'warning\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-yogi'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - Info', 'skt-yogi'),
		'desc' => __('<pre>
[message type="info"]This is a sample of the \'info\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-yogi'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - About', 'skt-yogi'),
		'desc' => __('<pre>
[message type="about"]This is a sample of the \'about\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-yogi'),
		'type' => 'info');

	$options[] = array(
		'name' => __('List Styles', 'skt-yogi'),
		'desc' => __('<pre>
[unordered_list style="list-1"]&lt;li&gt;List style 1&lt;/li&gt;[/unordered_list]
</pre>
<br />You can use above shortcode OR simply add class to ul. You can choose from list-1 to list-10 styles.<br />
<pre>
&lt;ul class="list-1"&gt;&lt;li&gt;List style 1&lt;/li&gt;&lt;/ul&gt;
</pre>
', 'skt-yogi'),
		'type' => 'info');
		
	
	$options[] = array(
		'name' => __('Horizontal Separator', 'skt-yogi'),
		'desc' => __('[hr_top] 
', 'skt-yogi'),
		'type' => 'info');	

	// Support					
	$options[] = array(
		'name' => __('Our Themes', 'skt-yogi'),
		'type' => 'heading');

	$options[] = array(
		'desc' => __('SKT Yogi WordPress theme has been Designed and Created by <a href="'.esc_url('http://sktthemes.net/').'" target="_blank">SKT Themes</a>', 'skt-yogi'),
		'type' => 'info');	

	 $options[] = array(
		'desc' => __('<a href="'.esc_url('http://sktthemes.net/').'" target="_blank"><img src="'.get_template_directory_uri().'/images/sktskill.jpg"></a>', 'skt-yogi'),
		'type' => 'info');	

	return $options;
}