<?php   
$frolic_page_builder = esc_html(__( 'Page Builder', 'frolic' ));
$frolic_page_builder_details = esc_html(__('Theme supports Page Builder. You can drag and drop our widgets with page builder visual editor.', 'frolic' ));
$frolic_page_layout = esc_html(__( 'Page Layout', 'frolic' ));
$frolic_page_layout_details = esc_html(__('Theme offers many different page layouts so you can quickly and easily create your pages with no hassle!', 'frolic' ));
$frolic_unlimited_sidebar = esc_html(__( 'Unlimited Sidebar', 'frolic' ));
$frolic_unlimited_sidebar_details = esc_html(__( 'Theme includes a different sidebar layouts. Unlimited sidebars allow you to create custom sidebars that match the style and layout of pages!', 'frolic' ));
$frolic_custom_widget = esc_html(__( 'Custom Widget', 'frolic' ));
$frolic_custom_widget_details = esc_html(__( 'We offer many custom widgets that are stylized and ready for use. Simply drag & drop into place to activate!', 'frolic' ));
$frolic_portfolio = esc_html(__( 'Multi Portfolio', 'frolic' ));
$frolic_portfolio_details = esc_html(__( 'Theme have a unlimited customization options in portfolio. You can use 2, 3, or 4 Columns with masonry layouts!', 'frolic' ));
$frolic_typography = esc_html(__( 'Typography', 'frolic' ));
$frolic_typography_details = esc_html(__('Theme loves typography, you can choose from over 500+ Google Fonts and Standard Fonts to customize your site!', 'frolic' ));
$frolic_slider = esc_html(__( 'Awesome Sliders', 'frolic' ));
$frolic_slider_details = esc_html(__('Theme includes Flex and Elastic sliders . You can use flexslider as a image,video and google map anywhere in your site.', 'frolic' ));
$frolic_woocommerce = esc_html(__( 'Woo Commerce', 'frolic' ));
$frolic_woocommerce_details = esc_html(__('Theme has full design/code integration for WooCommerce, your shop will look as good as the rest of your site!', 'frolic' ));
$frolic_retina_ready = esc_html(__( 'Retina Ready', 'frolic' ));
$frolic_retina_ready_details = esc_html(__( 'Theme is Retina Ready. So, Everything looks amazingly sharp and crisp on high resolution retina displays of all sizes!', 'frolic' ));
$frolic_icons = esc_html(__( 'Icons', 'frolic' ));
$frolic_icons_details = esc_html(__( ' Choose from over 2500 icons are fully integrated into the theme. Use them anywhere in your site with select your own size and color.', 'frolic' ));
$frolic_support = esc_html(__( 'Excellent Support', 'frolic' ));
$frolic_support_details = esc_html(__( 'We truly care about our customers and themes performance. We assure you that you will get the best after sale support like never before!', 'frolic' ));
$frolic_responsive_layout = esc_html(__( 'Responsive Layout', 'frolic' ));
$frolic_responsive_layout_details = esc_html( __('Theme is fully responsive and can adapt to any screen size. Resize your browser window to view it!', 'frolic' ));
$frolic_testimonials = esc_html( __( 'Testimonials', 'frolic' ));
$frolic_testimonials_details = esc_html( __( 'Display your clients\' glowing comments about your business on your homepage. Showing a specific number of testimonials with use of testimonial widget. ', 'frolic' ));
$frolic_social_media = esc_html( __( 'Social Media', 'frolic' ));
$frolic_social_media_details = esc_html( __( 'Want your users to stay in touch? No problem, Theme has Social Media icons all throughout the theme!', 'frolic' ));
$frolic_google_map = esc_html( __( 'Google Map', 'frolic' ));
$frolic_google_map_details = esc_html( __('Theme includes Goole Map widget. Find a place on the map and get directions. Or get info like business hours and menus, and see Street View imagery.', 'frolic' ));
$frolic_customization = esc_html( __( 'Customization', 'frolic' ));
$frolic_customization_details = esc_html( __('With advanced theme options, page options & extensive docs, its never been easier to customize a theme!', 'frolic' ));
$frolic_demo_content = esc_html( __( 'Demo content', 'frolic' ));
$frolic_demo_content_details = esc_html( __('Theme includes single click demo content. You can quickly setup the site like our demo and get started easily!', 'frolic' ));
$frolic_improvement = esc_html( __( 'Improvement', 'frolic' ));
$frolic_improvement_details = esc_html( __('We love our theme and customers. We are committed to improve and add new features to Theme!', 'frolic' ));

$frolic_view_demo = esc_html( __( 'View Demo', 'frolic'));
$frolic_upgrade_to_pro = esc_html( __( 'Upgrade To Pro', 'frolic' ));


$frolic_why_upgrade = <<< FEATURES

<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-cog"></i></div>
	<h3>$frolic_page_builder</h3>
	<p>$frolic_page_builder_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-th-large"></i></div>
	<h3>$frolic_page_layout</h3>
	<p>$frolic_page_layout_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-th"></i></div>
	<h3>$frolic_unlimited_sidebar</h3>
	<p>$frolic_unlimited_sidebar_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-code-fork"></i></div>
	<h3>$frolic_custom_widget</h3>
	<p>$frolic_custom_widget_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-list-alt"></i></div>
	<h3>$frolic_portfolio</h3>
	<p>$frolic_portfolio_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-font"></i></div>
	<h3>$frolic_typography</h3>
	<p>$frolic_typography_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-slideshare"></i></div>
	<h3>$frolic_slider</h3>
	<p>$frolic_slider_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-shopping-cart"></i></div>
	<h3>$frolic_woocommerce</h3>
	<p>$frolic_woocommerce_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
	<h3>$frolic_retina_ready</h3>
	<p>$frolic_retina_ready_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-dashboard"></i></div>
	<h3>$frolic_icons</h3>
	<p>$frolic_icons_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
	<h3>$frolic_support</h3>
	<p>$frolic_support_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-desktop"></i></div>
	<h3>$frolic_responsive_layout</h3>
	<p>$frolic_responsive_layout_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-rocket"></i></div>
	<h3>$frolic_testimonials</h3>
	<p>$frolic_testimonials_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-skype"></i></div>
	<h3>$frolic_social_media</h3>
	<p>$frolic_social_media_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-map-marker"></i></div>
	<h3>$frolic_google_map</h3>
	<p>$frolic_google_map_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-edit"></i></div>
	<h3>$frolic_customization</h3>
	<p>$frolic_customization_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-check"></i></div>
	<h3>$frolic_demo_content</h3>
	<p>$frolic_demo_content_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-signal"></i></div>
	<h3>$frolic_improvement</h3>
	<p>$frolic_improvement_details</p>
</div>
FEATURES;

function frolic_theme_page() {
	$title = esc_html(__('Frolic','frolic'));
	add_theme_page( 
		esc_html(__( 'Upgrade To Frolic Pro','frolic')),
		$title.'<i class="fa fa-plane theme-icon"></i>', 
		'edit_theme_options',
		'frolic_upgrade',
		'frolic_display_upgrade'
	);
}

add_action('admin_menu','frolic_theme_page');


function frolic_display_upgrade() {
  $theme_data = wp_get_theme('frolic'); 
    
    // Check for current viewing tab
    $tab = null;
    if ( isset( $_GET['tab'] ) ) {
        $tab = $_GET['tab'];
    } else {
        $tab = null;
    } 
     
    $pro_theme_url = 'https://genexthemes.com/downloads/frolic-pro/';
    $doc_url  = 'https://genexthemes.com/docs/free/frolic/';
    $support_url = 'https://genexthemes.com/free-support-request/';   
    
    $current_action_link =  admin_url( 'themes.php?page=frolic_upgrade&tab=pro_features' ); ?>
    <div class="frolic-wrapper about-wrap">
        <h1><?php printf(esc_html__('Welcome to %1$s - Version %2$s', 'frolic'), $theme_data->Name ,$theme_data->Version ); ?></h1><?php
       	printf( __('<div class="about-text">  Frolic is a Free Sports WordPress theme perfect for Sports related webites and Gym, Yoga, Fitness, health, wellness spa, massage center, weight loss, hospital, clinic,restaurants,cafe, physiotherapy, portfolio, photography and more business. However, due to its flexibility and easiness it can be used to create any types of sites. this Theme build in customizer it is very easy to use and user friendly.</div>', 'frolic') ); ?>
        <a href="https://genexthemes.com/" target="_blank" class="wp-badge welcome-logo"></a>   
        <p class="upgrade-btn"><a class="upgrade" href="<?php echo esc_url($pro_theme_url); ?>" target="_blank"><?php printf( __( 'Buy %1s Pro - $39', 'frolic'), $theme_data->Name ); ?></a></p>

	   <h2 class="nav-tab-wrapper">
	        <a href="?page=frolic_upgrade" class="nav-tab<?php echo is_null($tab) ? ' nav-tab-active' : null; ?>"><?php echo $theme_data->Name; ?></a>
	        <a href="?page=frolic_upgrade&tab=one_click_demo" class="nav-tab<?php echo $tab == 'one_click_demo' ? ' nav-tab-active' : null; ?>"><?php esc_html_e( 'Import Demo Data', 'frolic' );  ?></a>
	        <a href="?page=frolic_upgrade&tab=pro_features" class="nav-tab<?php echo $tab == 'pro_features' ? ' nav-tab-active' : null; ?>"><?php esc_html_e( 'PRO Features', 'frolic' );  ?></a>
            <a href="?page=frolic_upgrade&tab=free_vs_pro" class="nav-tab<?php echo $tab == 'free_vs_pro' ? ' nav-tab-active' : null; ?>"><?php esc_html_e( 'Free VS PRO', 'frolic' ); ?></a>
	        <?php do_action( 'frolic_admin_more_tabs' ); ?>
	    </h2>      

        <?php if ( is_null( $tab ) ) { ?>
            <div class="theme_info info-tab-content">
                <div class="theme_info_column clearfix">
                    <div class="theme_info_left">
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Theme Customizer', 'frolic' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('%s supports the Theme Customizer for all theme settings. Click "Customize" to start customize your site.', 'frolic'), $theme_data->Name); ?></p>
                            <p>
                                <a href="<?php echo admin_url('customize.php'); ?>" class="button button-primary"><?php esc_html_e('Start Customize', 'frolic'); ?></a>
                            </p>
                        </div>
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Theme Documentation', 'frolic' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('Need any help to setup and configure %s? Please have a look at our documentations instructions.', 'frolic'), $theme_data->Name); ?></p>
                            <p>
                                <a href="<?php echo esc_url($doc_url); ?>" target="_blank" class="button button-secondary"><?php esc_html_e(' Documentation', 'frolic'); ?></a>
                            </p>
                            <?php do_action( 'frolic_dashboard_theme_links' ); ?>
                        </div>  
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Having Trouble, Need Support?', 'frolic' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('Support for %s WordPress theme is conducted through Genex free support ticket system.', 'frolic'), $theme_data->Name); ?></p>
                            <p>  
                                <a href="<?php echo esc_url($support_url); ?>" target="_blank" class="button button-secondary"><?php echo sprintf( esc_html('Create a support ticket', 'frolic'), $theme_data->Name); ?></a>
                            </p>
                        </div> 
                       
                    </div>  
                    <div class="theme_info_right">
                        <?php echo sprintf ( '<img src="'. get_template_directory_uri() .'/screenshot.png" alt="%1$s" />',__('Theme screenshot','frolic') ); ?>
                    </div>
                </div> 
            </div>
        <?php } ?>
		<?php if ( $tab == 'one_click_demo' ) { ?>
            <div class="one-click-demo-tab info-tab-content">
				<div class="wrap clearfix">
					<?php
					if( ! function_exists('is_plugin_activate') ) {
						include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
					}
					if ( frolic_is_plugin_installed('One Click Demo Import') != 1 ) {
						echo sprintf('%1$s <a href="%2$s"> %3$s</a>', __('Install required plugin to import the demo content.','frolic'), admin_url('themes.php?page=tgmpa-install-plugins&plugin_status=install'), __('Begin Installing Plugin','frolic') );
					} elseif ( is_plugin_active( 'one-click-demo-import/one-click-demo-import.php' ) ) {	
						echo sprintf('<a href="%1$s"> %2$s</a>',  admin_url('themes.php?page=pt-one-click-demo-import'), __('Click here to install the demo','frolic') );
				    } else {
				    	echo sprintf('%1$s <a href="%2$s"> %3$s</a>', __('Kindly activate the Required plugin to Import the demo content.','frolic'), admin_url('themes.php?page=tgmpa-install-plugins&plugin_status=activate'), __('Begin Activating Plugin','frolic') );
				    } ?>
				</div>
			</div><?php   
		} ?> 
        <?php if ( $tab == 'pro_features' ) { ?>
            <div class="pro-features-tab info-tab-content"><?php
			    global $frolic_why_upgrade; ?>
				<div class="wrap clearfix">
				    <?php echo $frolic_why_upgrade; ?>
				</div>
			</div><?php   
		} ?>  

       <!-- Free VS PRO tab -->
        <?php if ( $tab == 'free_vs_pro' ) { ?>
            <div class="free-vs-pro-tab info-tab-content">
	            <div id="free_pro">
	                <table class="free-pro-table">
		                <thead>
			                <tr>
			                    <th></th>  
			                    <th><?php echo esc_html($theme_data->Name); ?> Lite</th>
			                    <th><?php echo esc_html($theme_data->Name); ?> PRO</th>
			                </tr>
		                </thead>
		                <tbody>
		                    <tr>
		                        <td><h3><?php _e('Flex Slider', 'frolic'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                        <td><h3><?php _e('Support', 'frolic'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                        <td><h3><?php _e('Responsive Design', 'frolic'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                        <td><h3><?php _e('Custom Logo Option', 'frolic'); ?></h3></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                        <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                         <td><h3><?php _e('Social Links', 'frolic'); ?></h3></td>
		                         <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                         <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	 <td><h3><?php _e('Unlimited color option', 'frolic'); ?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	 <td><h3><?php _e('Elastic Slider', 'frolic'); ?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	 <td><h3><?php _e('Page Builder Support', 'frolic');?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	 <td><h3><?php _e('Page Templates', 'frolic');?></h3></td>
		                    	 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	<td><h3><?php _e('Google Map', 'frolic');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    <tr>
		                    	<td><h3><?php _e('Demo Content', 'frolic');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Polylang Compatible', 'frolic');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Multiple Portfolio Layouts', 'frolic');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Multiple Blog Layouts', 'frolic');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Page Animation', 'frolic');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                     <tr>
		                    	<td><h3><?php _e('Unlimited Sidebar', 'frolic');?></h3></td>
		                    	<td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
		                    	<td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
		                    </tr>
		                    
		                    <tr class="ti-about-page-text-center">
		                        <td></td>
		                    	<td colspan="2"><a href="<?php echo esc_url($pro_theme_url); ?>" target="_blank" class="button button-primary button-hero"><?php printf( __( 'Buy %1s Pro', 'frolic'), $theme_data->Name ); ?></a></td>
		                    </tr>
		                </tbody>
	                </table>			    
				</div>
			</div><?php 
		} ?>

    </div><?php
}
  
   

	$options = array(
		'capability' => 'edit_theme_options',
		'type' => 'theme_mod',
		'panels' => apply_filters( 'frolic_customizer_options', array(
			'frolic' => array(
				'priority'       => 9,
				'title'          => __('Theme Options', 'frolic'),
				'description'    => __('Theme Options', 'frolic'),
				'sections' => array(
					'general' => array(
						'title' => __('General', 'frolic'),
						'description' => __('General settings that affects overall site', 'frolic'),
						'fields' => array(
							'breadcrumb' => array(
								'type' => 'checkbox',
								'label' => __('Enable Breadcrumb', 'frolic'),
								'default' => 1,
								'sanitize_callback' => 'frolic_boolean',
							),
							'breadcrumb_char' => array(
								'type' => 'select',
								'label' => __('Select Breadcrumb Character', 'frolic'),
								'choices' => array(
									'1' => '&raquo;',
									'2' => '&#47;',
									'3' => '&gt;'
								),
								'sanitize_callback' => 'frolic_breadcrumb_char_choices',
								'default' => '1',
							),
							 'numeric_pagination' => array(
                                'type' => 'checkbox',
                                'label' => __('Enable Numeric Page Navigation', 'frolic'),
                                'description' => __('Check to display numeric page navigation, instead of Previous Posts / Next Posts links.', 'frolic'),
                                'default' => 1, 
                                'sanitize_callback' => 'frolic_boolean', 
                            ),
                            'sidebar_position' => array(
                                'type' => 'radio',
                                'label' => __('Website Layout Options', 'frolic'),
                                'description' => __('Select main content and sidebar alignment.', 'frolic'),
                                'choices' => array(
                                    'left' => __('Sidebar Left', 'frolic'),
                                    'right' => __('Sidebar Right', 'frolic'),
                                    'fullwidth' => __('Full Width', 'frolic'),
                                    'no-sidebar' => __('No Sidebar', 'frolic'),
                                ),
                                'default' => 'right',  
                                'sanitize_callback' => 'frolic_sanitize_radio', 
                            ),
						),
					),
					'header' => array(
						'title' => __('Header', 'frolic'),
						'description' => __('Header options', 'frolic'),
						'fields' => array(
							'logo_title' => array(
								'type' => 'checkbox',
								'label' => __('Logo as Title', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',
							),
							'tagline' => array(
								'type' => 'checkbox',
								'label' => __('Show site Tagline', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',
							),
						),
					),
					'footer' => array(
						'title' => __('Footer', 'frolic'),
						'description' => __('Footer related options', 'frolic'),
						'fields' => array(
							'footer_widgets' => array(
								'type' => 'checkbox',
								'label' => __('Footer Widget Area', 'frolic'),
								'default' => 1,
								'sanitize_callback' => 'frolic_boolean',
							),
							'scroll_to_top' => array(
								'type' => 'checkbox',
								'label' => __('Enable Scroll To Top', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',
							),
							'copyright' => array(
                                'type' => 'textarea',
                                'label' => __('Footer Copyright Text (Validated that it\'s HTML Allowed)', 'frolic'),
                                'description' => __('HTML Allowed. <b>This field is even HTML validated! </b>', 'frolic'),
                                'sanitize_callback' => 'frolic_footer_copyright',
                            ),
						),
					),
					'home' => array(
						'title' => __('Home', 'frolic'),
						'description' => __('Home Page options', 'frolic'),
						'fields' => array(
							'slider_field' => array(   
								'type' => 'checkbox',
								'label' => __('Enable Home Page Slider Section', 'frolic'),
								'default' => 1,
								'sanitize_callback' => 'frolic_boolean',
							), 
							'slider_cat' => array(
								'type' => 'category',
								'label' => __('Slider Posts Category', 'frolic'),
								'sanitize_callback' => 'absint',
							),
							'slider_count' => array(
								'type' => 'text',
								'label' => __('No. of Sliders', 'frolic'),
								'sanitize_callback' => 'absint',
								'default' => 4,
							),
							'service_field' => array(   
								'type' => 'checkbox',
								'label' => __('Enable Home Page Service Section', 'frolic'),
								'default' => 1,
								'sanitize_callback' => 'frolic_boolean',
							),
							'service_section_icon_1' => array(
								'type' => 'icons-picker',
								'label' => __('Choose Service Section Icons #1', 'frolic'),
								'sanitize_callback' => 'sanitize_text_field',
							),
							'service_1' => array(
								'type' => 'dropdown-pages',
								'label' => __('Service Section #1', 'frolic'),
								'sanitize_callback' => 'absint',
							),
							'service_section_icon_2' => array(
								'type' => 'icons-picker',
								'label' => __('Choose Service Section Icons #2', 'frolic'),
								'sanitize_callback' => 'sanitize_text_field',
							),
							'service_2' => array(
								'type' => 'dropdown-pages',
								'label' => __('Service Section #2', 'frolic'),
								'sanitize_callback' => 'absint',
							),
							'service_section_icon_3' => array( 
								'type' => 'icons-picker',
								'label' => __('Choose Service Section Icons #3', 'frolic'),
								'sanitize_callback' => 'sanitize_text_field',
							),
							'service_3' => array(
								'type' => 'dropdown-pages',
								'label' => __('Service Section #3', 'frolic'),
								'sanitize_callback' => 'absint',
							),
							'service_section_icon_4' => array( 
								'type' => 'icons-picker',
								'label' => __('Choose Service Section Icons #4', 'frolic'),
								'sanitize_callback' => 'sanitize_text_field',
							),
							'service_4' => array(
								'type' => 'dropdown-pages',
								'label' => __('Service Section #4', 'frolic'),
								'sanitize_callback' => 'absint',
							),
							'enable_recent_post_service' => array(
                                'type' => 'checkbox',
                                'label' => __('Enable Home Page Recent Post Section', 'frolic'),
                                'description' => __('Enable recent post section in home page', 'frolic'),
                                'default' => 1,
                                'sanitize_callback' => 'frolic_boolean',  
                            ), 
							'recent_posts_count' => array(
								'type' => 'text',
								'label' => __('No. of Recent Posts', 'frolic'),
								'sanitize_callback' => 'absint',
								'default' => 4,  
							), 
							'recent_posts_exclude' => array(
								'type' => 'text',
								'label' => __('Exclude the Posts from Home Page.Post IDs, separated by commas', 'frolic'),
								'description' => __('Post IDs, separated by commas.','frolic'),
								'sanitize_callback' => 'sanitize_text_field', 
							),
							'enable_home_default_content' => array(
                                'type' => 'checkbox',
                                'label' => __('Enable Home Page Default Content', 'frolic'),
                                'description' => __('Enable home page default content', 'frolic'),
                                'default' => 0,  
                                'sanitize_callback' => 'frolic_boolean',
                            ),
						),
					),
					'blog' => array(
						'title' => __('Blog', 'frolic'),
						'description' => __('Blog Related Posts options', 'frolic'),
						'fields' => array(
							'featured_image' => array(  
								'type' => 'checkbox',
								'label' => __('Enable Featured Image', 'frolic'),
								'default' => 1,
								'sanitize_callback' => 'frolic_boolean',
							),
                           'featured_image_size' => array(
                                'type' => 'radio',
                                'label' => __('Choose the featured image display type for Blog Page ', 'frolic'),
                                'choices' => array(
                                    '1' => __('Large Featured Image', 'frolic'),
                                    '2' => __('Small Featured Image', 'frolic'),        
                                ),
                                'default' => '1', 
                                'sanitize_callback' => 'absint',
                            ),
						),
					),
					'single_blog' => array(
						'title' => __('Single Blog', 'frolic'),
						'description' => __('Single Blog page Related Posts options', 'frolic'),
						'fields' => array(
							'single_featured_image' => array(
								'type' => 'checkbox',
								'label' => __('Enable Single Post Featured Image', 'frolic'),
								'default' => 1,
								'sanitize_callback' => 'frolic_boolean',
							),
							'single_featured_image_size' => array(
								'type' => 'radio',
								'label' => __('Choose the featured image display type for Single Page ', 'frolic'),
								'choices' => array(
									'1' => __('Large Featured Image', 'frolic'),
									'2' => __('Small Featured Image', 'frolic'),       
								),
								'default' => '1', 
								'sanitize_callback' => 'absint',  
							),
							'social_sharing_box' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Social Sharing Box below single post', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',    
							),
							'facebook_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Facebook Sharing option below single post', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',    
							),
							'twitter_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Twitter Sharing option below single post', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',    
							),
							'linkedin_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Linkedin Sharing option below single post', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',    
							),
							'google-plus_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Google Plus Sharing option below single post', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',    
							),
							'email_sb' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Email Sharing option below single post', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',    
							),
							'author_bio_box' => array(
								'type' => 'checkbox',
								'label' => __(' Enable Author Bio Box below single post', 'frolic'),
								'default' => 0,
								'sanitize_callback' => 'frolic_boolean',    
							),
							'related_posts' => array(
								'type' => 'checkbox',
								'label' => __('Show Related posts', 'frolic'),
								'default' => 0, 
								'sanitize_callback' => 'frolic_boolean', 
							),
							'related_posts_hierarchy' => array(
								'type' => 'radio',
								'label' => __('Related Posts Must Be Shown As:', 'frolic'),
								'choices' => array(
									'1' => __('Related Posts By Tags', 'frolic'),
									'2' => __('Related Posts By Categories', 'frolic'),      
								),
								'default' => '1', 
								'sanitize_callback' => 'absint',    
							),
						),
					),
				)
			),
		) 
	)
);

function frolic_boolean($value) {
	if(is_bool($value)) {
		return $value;
	} else {
		return false;
	}
}
function frolic_sanitize_radio( $value, $setting ) {

  // Ensure input is a slug.
  $input = sanitize_key( $value );

  // Get list of choices from the control associated with the setting.
  $choices = $setting->manager->get_control( $setting->id )->choices;

  // If the input is a valid key, return it; otherwise, return the default.
  return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}

function frolic_breadcrumb_char_choices($value='') {
	$choices = array('1','2','3');

	if( in_array($value, $choices)) {
		return $value;
	} else {
		return '1';
	}
}

if ( ! function_exists( 'frolic_footer_copyright' ) ) {

    function frolic_footer_copyright($string) {
        $allowed_tags = array(    
                            'a' => array(
                            	'href' => array(),
								'title' => array(),
								'target' => array(),
                            ),
							'img' => array(
								'src' => array(),  
								'alt' => array(),
							),
							'p' => array(),
							'br' => array(),
							'em' => array(),
                            'strong' => array(),
        );
        return wp_kses( $string,$allowed_tags);

    }
}

