<?php
/**
 * The Header for our theme.
 * @package The WP Fitness
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <link rel="profile" href="<?php echo esc_url( __( 'http://gmpg.org/xfn/11', 'the-wp-fitness' ) ); ?>">
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

  <?php if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
  } else {
    do_action( 'wp_body_open' );
  }?>

  <?php if(get_theme_mod('the_wp_fitness_preloader',true)){ ?>
    <div id="overlayer"></div>
    <span class="tg-loader">
      <span class="tg-loader-inner"></span>
    </span>
  <?php }?>
  
  <header role="banner">
    <a class="screen-reader-text skip-link" href="#maincontent"><?php esc_html_e( 'Skip to content', 'the-wp-fitness' ); ?><span class="screen-reader-text"><?php esc_html_e( 'Skip to content', 'the-wp-fitness' ); ?></span></a>
    <div id="header">
      <?php if(get_theme_mod('the_wp_fitness_top_header')){ ?>
        <div class="header-top">
          <div class="container">
            <div class="row">
              <div class="top-contact col-lg-3 col-md-3">
                <?php if( get_theme_mod( 'the_wp_fitness_contact_corporate','' ) != '') { ?>
                  <span class="call"><i class="fa fa-phone" aria-hidden="true"></i><?php echo esc_html( get_theme_mod('the_wp_fitness_contact_corporate','' )); ?></span>
                <?php } ?>
              </div>   
              <div class="top-contact col-lg-4 col-md-4">
                <?php if( get_theme_mod( 'the_wp_fitness_email_corporate','' ) != '') { ?>
                  <span class="email_corporate"><i class="fa fa-envelope" aria-hidden="true"></i><?php echo esc_html( get_theme_mod('the_wp_fitness_email_corporate','') ); ?></span>
                <?php } ?>
              </div>
              <div class="social-media col-lg-5 col-md-5">
                <?php if( get_theme_mod( 'the_wp_fitness_youtube_url' ) != '') { ?>
                  <a href="<?php echo esc_url( get_theme_mod( 'the_wp_fitness_youtube_url','' ) ); ?>"><i class="fab fa-youtube" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Youtube', 'the-wp-fitness' ); ?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'the_wp_fitness_facebook_url') != '') { ?>
                  <a href="<?php echo esc_url( get_theme_mod( 'the_wp_fitness_facebook_url','' ) ); ?>"><i class="fab fa-facebook-f" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Facebook', 'the-wp-fitness' ); ?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'the_wp_fitness_twitter_url') != '') { ?>
                  <a href="<?php echo esc_url( get_theme_mod( 'the_wp_fitness_twitter_url','' ) ); ?>"><i class="fab fa-twitter" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'Twitter', 'the-wp-fitness' ); ?></span></a>
                <?php } ?>
                <?php if( get_theme_mod( 'the_wp_fitness_rss_url') != '') { ?>
                  <a href="<?php echo esc_url( get_theme_mod( 'the_wp_fitness_rss_url','' ) ); ?>"><i class="fas fa-rss" aria-hidden="true"></i><span class="screen-reader-text"><?php esc_html_e( 'RSS', 'the-wp-fitness' ); ?></span></a>
                <?php } ?>
              </div>
              <div class="clearfix"></div>
            </div>
          </div>
        </div>
      <?php }?>
      <div class="toggle-menu responsive-menu">
        <button onclick="the_wp_fitness_resMenu_open()"><i class="fas fa-bars"></i><?php esc_html_e('Menu','the-wp-fitness'); ?><span class="screen-reader-text"><?php esc_html_e('Menu','the-wp-fitness'); ?></span></button>
      </div>
      <div class="menu-sec <?php if( get_theme_mod( 'the_wp_fitness_sticky_header') != '') { ?> sticky-header"<?php } else { ?>close-sticky <?php } ?>">
        <div class="container">
          <div class="row">
            <div class="logo col-lg-4 col-md-4 wow bounceInDown">
              <?php if ( has_custom_logo() ) : ?>
                <div class="site-logo"><?php the_custom_logo(); ?></div>
              <?php else: ?>
                <?php $blog_info = get_bloginfo( 'name' ); ?>
                <?php if ( ! empty( $blog_info ) ) : ?>
                  <?php if ( is_front_page() && is_home() ) : ?>
                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                  <?php else : ?>
                    <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                  <?php endif; ?>
                <?php endif; ?>
                <?php
                $description = get_bloginfo( 'description', 'display' );
                if ( $description || is_customize_preview() ) :
                  ?>
                  <p class="site-description">
                    <?php echo esc_html($description); ?>
                  </p>
                <?php endif; ?>
              <?php endif; ?>
            </div>        
            <div class="menubox col-lg-8 col-md-8">
              <div id="sidelong-menu" class="nav side-nav">
                <nav id="primary-site-navigation" class="nav-menu" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'the-wp-fitness' ); ?>">
                  <?php 
                    wp_nav_menu( array( 
                      'theme_location' => 'primary',
                      'container_class' => 'main-menu-navigation clearfix' ,
                      'menu_class' => 'clearfix',
                      'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                      'fallback_cb' => 'wp_page_menu',
                    ) ); 
                  ?>
                  <a href="javascript:void(0)" class="closebtn responsive-menu" onclick="the_wp_fitness_resMenu_close()"><?php esc_html_e('Close Menu','the-wp-fitness'); ?><i class="fas fa-times-circle"></i><span class="screen-reader-text"><?php esc_html_e('Close Menu','the-wp-fitness'); ?></span></a>
                </nav>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </header>