<?php
/**
 * SKT Yogi functions and definitions
 *
 * @package SKT Yogi
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
function content($limit) {
$content = explode(' ', get_the_excerpt(), $limit);
if (count($content)>=$limit) {
array_pop($content);
$content = implode(" ",$content).'...';
} else {
$content = implode(" ",$content);
}	
$content = preg_replace('/\[.+\]/','', $content);
$content = apply_filters('the_content', $content);
$content = str_replace(']]>', ']]&gt;', $content);
return $content;
}

if ( ! function_exists( 'skt_yogi_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function skt_yogi_setup() {

	if ( ! isset( $content_width ) )
		$content_width = 640; /* pixels */

	load_theme_textdomain( 'skt-yogi', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'title-tag' );
	add_image_size('homepage-thumb',240,145,true);	
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'skt-yogi' ),
		'footer' => __( 'Footer Menu', 'skt-yogi' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_editor_style( 'editor-style.css' );
}
endif; // skt_yogi_setup
add_action( 'after_setup_theme', 'skt_yogi_setup' );

function skt_yogi_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'skt-yogi' ),
		'description'   => __( 'Appears on blog page sidebar', 'skt-yogi' ),
		'id'            => 'sidebar-1',
		'before_widget' => '',		
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3><aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar Main', 'skt-yogi' ),
		'description'   => __( 'Appears on page sidebar', 'skt-yogi' ),
		'id'            => 'sidebar-main',
		'before_widget' => '',		
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3><aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
	) );	
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 1', 'skt-yogi' ),
		'description'   => __( 'Appears on footer', 'skt-yogi' ),
		'id'            => 'footer-1',
		'before_widget' => '<div id="%1$s" class="cols-3 widget-column-1">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 2', 'skt-yogi' ),
		'description'   => __( 'Appears on footer', 'skt-yogi' ),
		'id'            => 'footer-2',
		'before_widget' => '<div id="%1$s" class="cols-3 widget-column-2">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 3', 'skt-yogi' ),
		'description'   => __( 'Appears on footer', 'skt-yogi' ),
		'id'            => 'footer-3',
		'before_widget' => '<div id="%1$s" class="cols-3 widget-column-3">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
		register_sidebar( array(
		'name'          => __( 'Footer Widget 4', 'skt-yogi' ),
		'description'   => __( 'Appears on footer', 'skt-yogi' ),
		'id'            => 'footer-4',
		'before_widget' => '<div id="%1$s" class="cols-3 widget-column-4">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
	
	register_sidebar( array(
		'name'          => __( 'Sidebar Contact Page', 'skt-yogi' ),
		'description'   => __( 'Appears on contact page', 'skt-yogi' ),
		'id'            => 'sidebar-contact',
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Header Widget', 'skt-yogi' ),
		'description'   => __( 'Appears on header', 'skt-yogi' ),
		'id'            => 'header-widget',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '<h6 style="display:none">',
		'after_title'   => '</h6>',
	) );
		

}
add_action( 'widgets_init', 'skt_yogi_widgets_init' );

define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/inc/' );
require_once get_template_directory() . '/inc/options-framework.php';

function skt_yogi_scripts() {
	
	wp_enqueue_style( 'skt_yogi-gfonts-opensans', '//fonts.googleapis.com/css?family=Open+Sans:400,800,700,600,300' );
	
	wp_enqueue_style( 'skt_yogi-gfonts-roboto', '//fonts.googleapis.com/css?family=Roboto:400,100,300,500,700' );	
	wp_enqueue_style( 'skt_yogi-gfonts-robotocondensed', '//fonts.googleapis.com/css?family=Roboto+Condensed:400,300,300italic,400italic,700' );	
	wp_enqueue_style( 'skt_yogi-gfonts-lato', '//fonts.googleapis.com/css?family=Lato:400,100,100italic,300,300italic,400italic,700,700italic,900,900italic' );
	wp_enqueue_style( 'skt_yogi-gfonts-ptsans', '//fonts.googleapis.com/css?family=PT+Sans:400,400italic,700,700italic' );	
	wp_enqueue_style( 'skt_yogi-gfonts-raleway', '//fonts.googleapis.com/css?family=Raleway:400,100,200,300,500,600,700,900,800' );
	
	
	if( of_get_option('bodyfontface',true) != '' ){
		wp_enqueue_style( 'skt_yogi-gfonts-body', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('bodyfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if( of_get_option('logofontface',true) != '' ){
		wp_enqueue_style( 'skt_yogi-gfonts-logo', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('logofontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('navfontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-nav', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('navfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('headfontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-heading', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('headfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('hdrtopfontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-hdrtopfontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('hdrtopfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('slidetitlefontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-slidetitlefontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('slidetitlefontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('slidedescfontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-slidedescfontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('slidedescfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('h1fontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-h1fontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('h1fontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('h2fontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-h2fontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('h2fontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('h3fontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-h3fontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('h3fontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('h4fontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-h4fontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('h4fontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('h5fontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-h5fontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('h5fontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('h6fontface', true) != '' ) {
		wp_enqueue_style( 'skt_yogi-gfonts-h6fontface', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('h6fontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}

	wp_enqueue_style( 'skt_yogi-basic-style', get_stylesheet_uri() );
	wp_enqueue_style( 'skt_yogi-editor-style', get_template_directory_uri().'/editor-style.css' );
	wp_enqueue_style( 'skt_yogi-base-style', get_template_directory_uri().'/css/style_base.css' );	
	if ( is_home() || is_front_page() ) { 
	wp_enqueue_style( 'skt_yogi-nivo-style', get_template_directory_uri().'/css/nivo-slider.css' );
	wp_enqueue_script( 'skt_yogi-nivo-slider', get_template_directory_uri() . '/js/jquery.nivo.slider.js', array('jquery') );
	}	
	wp_enqueue_style( 'skt_yogi-prettyphoto-style', get_template_directory_uri().'/css/prettyPhoto.css' );
	wp_enqueue_script( 'skt_yogi-prettyphoto-script', get_template_directory_uri() . '/js/jquery.prettyPhoto.js', array('jquery') );
	wp_enqueue_script( 'skt_yogi-customscripts', get_template_directory_uri() . '/js/custom.js', array('jquery') );
	wp_enqueue_script( 'skt_yogi-smooth-scroll', get_template_directory_uri() . '/js/smooth-scroll.js', array('jquery') );
	wp_enqueue_script( 'skt_yogi-filter-scripts', get_template_directory_uri().'/js/filter-gallery.js' );
	wp_enqueue_style( 'skt_yogi-font-awesome-style', get_template_directory_uri().'/css/font-awesome.css' );	
	wp_enqueue_script( 'skt_yogi-testimonialsminjs', get_template_directory_uri().'/testimonialsrotator/js/jquery.quovolver.min.js', array('jquery') );
	wp_enqueue_script( 'skt_yogi-testimonials-bootstrap', get_template_directory_uri().'/testimonialsrotator/js/bootstrap.js', array('jquery') );
	wp_enqueue_style( 'skt_yogi-testimonialslider-style', get_template_directory_uri().'/testimonialsrotator/js/tm-rotator.css' );		
	wp_enqueue_style( 'skt_yogi-animation-style', get_template_directory_uri().'/css/animation.css' );
	wp_enqueue_style( 'skt_yogi-responsive-style', get_template_directory_uri().'/css/theme-responsive.css' );		
	wp_enqueue_style( 'skt_yogi-owl-style', get_template_directory_uri().'/testimonialsrotator/js/owl.carousel.css' );
	wp_enqueue_script( 'skt_yogi-owljs', get_template_directory_uri().'/testimonialsrotator/js/owl.carousel.js', array('jquery') );
	
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'skt_yogi_scripts' );

function media_css_hook(){
	
	?>
    	
    	<script>
			jQuery(window).bind('scroll', function() {
	var wwd = jQuery(window).width();
	if( wwd > 939 ){
		var navHeight = jQuery( window ).height() - 0;
		<?php if( of_get_option('headstick',true) != true) { ?>
		if (jQuery(window).scrollTop() > navHeight) {
			jQuery(".header").addClass('fixed');
		}else {
			jQuery(".header").removeClass('fixed');
		}
		<?php } ?>
	}
});
		jQuery(window).load(function() {
        jQuery('#slider').nivoSlider({
        	effect:'<?php echo of_get_option('slideefect',true); ?>', //sliceDown, sliceDownLeft, sliceUp, sliceUpLeft, sliceUpDown, sliceUpDownLeft, fold, fade, random, slideInRight, slideInLeft, boxRandom, boxRain, boxRainReverse, boxRainGrow, boxRainGrowReverse
		  	animSpeed: <?php echo of_get_option('slideanim',true); ?>,
			pauseTime: <?php echo of_get_option('slidepause',true); ?>,
			directionNav: <?php echo of_get_option('slidenav',true); ?>,
			controlNav: <?php echo of_get_option('slidepage',true); ?>,
			pauseOnHover: <?php echo of_get_option('slidepausehover',true); ?>,
    });
});


jQuery(document).ready(function() {
  
  jQuery('.link').on('click', function(event){
    var $this = jQuery(this);
    if($this.hasClass('clicked')){
      $this.removeAttr('style').removeClass('clicked');
    } else{
      $this.css('background','#7fc242').addClass('clicked');
    }
  });
 
});
		</script>
<?php 
}
add_action('wp_head','media_css_hook'); 

function skt_yogi_custom_head_codes() { 
	if ( function_exists('of_get_option') ){
		if ( of_get_option('style2', true) != '' ) {
			echo "<style>". esc_html( of_get_option('style2', true) ) ."</style>";
		}
		echo "<style>";
		if ( of_get_option('bodyfontface', true) != '') {
			echo 'body, .price-table, .header span.tagline{font-family:\''. esc_html( of_get_option('bodyfontface', true) ) .'\', sans-serif;}';
		}
		if ( of_get_option('bodyfontcolor', true) != '' ) {
			echo 'body, .wrap_two a.linkreadmore:hover, .contact-form-section .address,  .accordion-box .acc-content, .header span.tagline{color:'. esc_html( of_get_option('bodyfontcolor', true) ) .';}';
		}
		if( of_get_option('bodyfontsize',true) != ''){
			echo "body, .header span.tagline{font-size:".of_get_option('bodyfontsize',true)."}";
		}
		if( of_get_option('logofontface',true) != '' || of_get_option('logofontcolor',true) != '' || of_get_option('logofontsize',true) != ''){
			echo ".header .header-inner .logo h1, .header .header-inner .logo a {font-family:".of_get_option('logofontface').";color:".of_get_option('logofontcolor',true).";font-size:".of_get_option('logofontsize',true)."}";
		}
		if( of_get_option('logofontcolor',true) != '' ){
			echo ".header span.tagline{color:".of_get_option('logofontcolor',true).";}";
		}	
		if( of_get_option('hdrtopfontface',true) != '' || of_get_option('hdrtopfontcolor',true) != '' || of_get_option('hdrtopfontsize',true) != '' || of_get_option('hdrtopbgcolor',true) != ''){
			echo ".signin_wrap {font-family:".of_get_option('hdrtopfontface').";color:".of_get_option('hdrtopfontcolor',true).";font-size:".of_get_option('hdrtopfontsize',true)."; background-color:".of_get_option('hdrtopbgcolor',true)."}";
		}		
		if ( of_get_option('navfontface', true) != '' || of_get_option('navfontsize',true) != '' ) {
			echo '.header .header-inner .nav ul{font-family:\''. esc_html( of_get_option('navfontface', true) ) .'\', sans-serif;font-size:'.of_get_option('navfontsize',true).'}';
		}
		if ( of_get_option('navfontcolor', true) != '' ) {
			echo '.header .header-inner .nav ul li a, .header .header-inner .nav ul li.current_page_item ul li a{color:'. esc_html( of_get_option('navfontcolor', true) ) .';}';
		}
		if ( of_get_option('navhovercolor', true) != '') {
			echo '.header .header-inner .nav ul li a:hover, .header .header-inner .nav ul li.current_page_item a, .header .header-inner .nav ul li.current_page_item ul li a:hover, .header .header-inner .nav ul li.current-menu-ancestor a.parent{ color:'. esc_html( of_get_option('navhovercolor', true) ) .';}';
		}	
		if( of_get_option('sectitlesize',true) != ''){
			echo "h2.section_title{font-size:".of_get_option('sectitlesize',true)."}";
		}		
		if ( of_get_option('headfontface', true) != '' || of_get_option('sectitlecolor',true) != '' || of_get_option('sectitlebdcolor',true) != '' ) {
			echo 'h2.section_title{font-family:\''. esc_html( of_get_option('headfontface', true) ) .'\', sans-serif;  border-color:'.of_get_option('sectitlebdcolor',true).'; color:'.of_get_option('sectitlecolor',true).'}';
		}
		
		if( of_get_option('pagestitlebdcolor',true) != ''){
			echo "h1.entry-title, h1.page-title, .blog-post-repeat .postmeta{border-color:".of_get_option('pagestitlebdcolor',true)."}";
		}			
		
		if ( of_get_option('sectitlebdcolor', true) != '' ) {
			echo '.cols-3 h5 span{border-color:'. esc_html( of_get_option('sectitlebdcolor', true) ) .';}';
		}
		if ( of_get_option('linkcolor', true) != '' ) {
			echo 'a, .tabs-wrapper ul.tabs li a, .slide_toggle a{color:'. esc_html( of_get_option('linkcolor', true) ) .';}';
		}
		if ( of_get_option('linkhovercolor', true) != '' ) {
			echo 'a:hover, .tabs-wrapper ul.tabs li a:hover, .slide_toggle a:hover{color:'. esc_html( of_get_option('linkhovercolor', true) ) .';}';
		}			
		if( of_get_option('foottitlecolor', true) != '' || of_get_option('ftfontsize', true) != '' ){
			echo ".cols-3 h5{color:".of_get_option('foottitlecolor', true)."; font-size:".of_get_option('ftfontsize', true)."; }";
		}		
		if( of_get_option('footdesccolor', true) != ''){
			echo ".cols-3{color:".of_get_option('footdesccolor', true).";}";
		}					
		if( of_get_option('copycolor', true) != ''){
			echo ".copyright-txt{color:".of_get_option('copycolor',true)."}";
		}
		if ( of_get_option('headerbg', true) != '' ) {
			echo ".header, .header .header-inner .nav ul li:hover > ul{background-color:".of_get_option('headerbg',true).";}";
		}		
// section 1 three boxes	
		if ( of_get_option('columbgcolor1', true) != '' ) {
			echo ".services-wrap .columbgcolor1{background-color:".of_get_option('columbgcolor1',true).";}";
		}
		if ( of_get_option('columbgcolor2', true) != '' ) {
			echo ".services-wrap .columbgcolor2{background-color:".of_get_option('columbgcolor2',true).";}";
		}
		if ( of_get_option('columbgcolor3', true) != '' ) {
			echo ".services-wrap .columbgcolor3{background-color:".of_get_option('columbgcolor3',true).";}";
		}
		if ( of_get_option('linkreadmore', true) != '' || of_get_option('linkreadmorebd', true) != '' ) {
			echo ".services-wrap a.rdmore{color:".of_get_option('linkreadmore',true)."; border-color:".of_get_option('linkreadmorebd',true).";}";
		}		
		if ( of_get_option('linkreadmorebg', true) != '') {
			echo ".services-wrap a.rdmore:hover{background-color:".of_get_option('linkreadmorebg',true).";}";
		}
		if ( of_get_option('columtextcolor1', true) != '' ) {
			echo ".services-wrap .columbgcolor1{color:".of_get_option('columtextcolor1',true).";}";
		}
		if ( of_get_option('columtextcolor2', true) != '' ) {
			echo ".services-wrap .columbgcolor2{color:".of_get_option('columtextcolor2',true).";}";
		}
		if ( of_get_option('columtextcolor3', true) != '' ) {
			echo ".services-wrap .columbgcolor3{color:".of_get_option('columtextcolor3',true).";}";
		}
		if ( of_get_option('colum1titlecolor', true) != '' ) {
			echo ".services-wrap .columbgcolor1 h3{color:".of_get_option('colum1titlecolor',true).";}";
		}
		if ( of_get_option('colum2titlecolor', true) != '' ) {
			echo ".services-wrap .columbgcolor2 h3{color:".of_get_option('colum2titlecolor',true).";}";
		}
		if ( of_get_option('colum3titlecolor', true) != '' ) {
			echo ".services-wrap .columbgcolor3 h3{color:".of_get_option('colum3titlecolor',true).";}";
		}
// Our Classes and Trainer and blog
		if ( of_get_option('classestrainerbgcolor', true) != '') {
			echo ".ourclasses_col, .ourclasses_col:hover a.rdmore{background:".of_get_option('classestrainerbgcolor',true).";}";
		}
		if ( of_get_option('classestrainerhvbgcolor', true) != '') {
			echo ".ourclasses_col:hover, .news a.linkreadmore:hover, .wrap_two a.linkreadmore{background:".of_get_option('classestrainerhvbgcolor',true).";}";
		}
		if ( of_get_option('classestrainerdescolor', true) != '') {
			echo ".ourclasses_col .day_time{color:".of_get_option('classestrainerdescolor',true).";}";
		}
		if ( of_get_option('classestrainerdeshvcolor', true) != '') {
			echo ".ourclasses_col:hover h3, .ourclasses_col:hover .day_time, .wrap_two a.linkreadmore{color:".of_get_option('classestrainerdeshvcolor',true).";}";
		}				
		if ( of_get_option('classestrainerbdcolor', true) != '' ) {
			echo ".ourclasses_col, .section-teammember .ourclasses_col, .ourclasses_col a.rdmore, .news a.linkreadmore, .wrap_two a.linkreadmore{border-color:".of_get_option('classestrainerbdcolor',true).";}";
		}
		
		if ( of_get_option('servicesimgborder', true) != '' ) {
			echo ".services-wrap .one_third img{border-color:".of_get_option('servicesimgborder',true).";}";
		}
// Join Our yogasana Club
		if ( of_get_option('joinouryogasanaclub', true) != '' ) {
			echo '#joinourclub, #joinourclub h3, #joinourclub a.signuonow{color:'. esc_html( of_get_option('joinouryogasanaclub', true) ) .';}';
		}
		if ( of_get_option('signupnowbgcolor', true) != '' ) {
			echo '#joinourclub a.signuonow{background:'. esc_html( of_get_option('signupnowbgcolor', true) ) .';}';
		}
		if ( of_get_option('signupnowhvbgcolor', true) != '' ) {
			echo '#joinourclub a.signuonow:hover{background:'. esc_html( of_get_option('signupnowhvbgcolor', true) ) .';}';
		}
		if( of_get_option('socialfontcolor',true) != '' || of_get_option('socialbgcolor',true) != '' || of_get_option('socialstyle',true) != '' ){
			echo ".social-icons a{color:".of_get_option('socialfontcolor',true)."; background:".of_get_option('socialbgcolor',true)."; border-radius:".of_get_option('socialstyle', true)."%;}";
		}
		if( of_get_option('socialfonthvcolor',true) != '' ||  of_get_option('socialbghvcolor',true) != ''){
			echo ".social-icons a:hover{color:".of_get_option('socialfonthvcolor',true)."; background:".of_get_option('socialbghvcolor',true)."; }";
		}	
		if( of_get_option('btnbgcolor',true) != '' || of_get_option('btntxtcolor', true) != '' || of_get_option('btnbordercolor', true) != ''){
			echo ".button, #commentform input#submit, input.search-submit, .post-password-form input[type=submit], p.read-more a, .accordion-box h2:before, .pagination ul li span, .pagination ul li a, #contactform_main input[type=submit], .wpcf7 form input[type=submit]{background-color:".of_get_option('btnbgcolor',true)." !important; color:". of_get_option('btntxtcolor', true) ." !important; border-bottom:4px solid ". of_get_option('btnbordercolor', true) ." !important; }";
		}
		if( of_get_option('btnbghvcolor',true) != '' || of_get_option('btntxthvcolor', true) != '' || of_get_option('btnborderhvcolor', true) != '' ){
			echo ".button:hover, #commentform input#submit:hover, input.search-submit:hover, .post-password-form input[type=submit]:hover, p.read-more a:hover, .pagination ul li .current, .pagination ul li a:hover, #contactform_main input[type=submit]:hover, .wpcf7 form input[type=submit]:hover{background-color:".of_get_option('btnbghvcolor',true)." !important; color:". esc_html( of_get_option('btntxthvcolor', true) ) ." !important; border-bottom:4px solid ". of_get_option('btnborderhvcolor', true) ." !important;}";
		}
		if( of_get_option('searchbgcolor',true) != ''){
			echo ".searchbox-icon, .searchbox-submit {background-color:".of_get_option('searchbgcolor',true)."; }";
		}
		if( of_get_option('galleryactivebc',true) != ''){
			echo ".photobooth .filter-gallery ul li.current a{border-bottom:3px solid ".of_get_option('galleryactivebc',true)."; }";
		}
		if( of_get_option('searchbgcolor',true) != ''){
			echo ".wrap_one .fa {color:".of_get_option('searchbgcolor',true)."; }";
		}
		if( of_get_option('fsh2color',true) != ''){
			echo ".wrap_one h2 {color:".of_get_option('fsh2color',true)."; }";
		}
		if( of_get_option('tbfontcolor', true) != '' || of_get_option('tbbtnborder', true) != ''){
			echo ".btnfeatures { color:". of_get_option('tbfontcolor', true) ."; border:1px solid ". of_get_option('tbbtnborder', true) ."; }";
		}
		if( of_get_option('tbfonthvcolor', true) != '' || of_get_option('tbbtnhvborder', true) != ''){
			echo ".btnfeatures:hover { color:". of_get_option('tbfonthvcolor', true) ."; border:1px solid ". of_get_option('tbbtnhvborder', true) ."; }";
		}
		if ( of_get_option('widgettitlebgcolor', true) != '' || of_get_option('wdgttitleccolor', true) != '' ) {
			echo "h3.widget-title{background-color:".of_get_option('widgettitlebgcolor', true)."; color:".of_get_option('wdgttitleccolor', true).";}";
		}
		if ( of_get_option('footerbgcolor', true) != '' ) {
			echo "#footer-wrapper{background-color:".of_get_option('footerbgcolor', true)."; }";
		}			
		if ( of_get_option('footermenucolor', true) != '' ) {
			echo ".cols-3 ul li a{color:".of_get_option('footermenucolor', true)."; }";
		}
		if ( of_get_option('footermenucurrent', true) != '' ) {
			echo ".cols-3 ul li a:hover, .cols-3 ul li.current_page_item a{color:".of_get_option('footermenucurrent', true)."; }";
		}			
		if ( of_get_option('copybgcolor', true) != '' ) {
			echo '.copyright-wrapper{background-color:'. esc_html( of_get_option('copybgcolor', true) ) .';}';
		}
		if( of_get_option('galhvcolor',true) != ''){
			echo ".photobooth .gallery ul li:hover{ background:".of_get_option('galhvcolor',true)."; float:left; background:url(".get_template_directory_uri()."/images/camera-icon.png) 50% 50% no-repeat ".of_get_option('galhvcolor',true)."; }";
		}				
		if( of_get_option('sldpagebg',true) != ''){
			echo ".nivo-controlNav a{background-color:".of_get_option('sldpagebg',true)."}";
		}
		if( of_get_option('sldpagehvbg',true) != ''){
			echo ".nivo-controlNav a.active{background-color:".of_get_option('sldpagehvbg',true)."}";
		}				
		if( of_get_option('sidebarfontcolor',true) != '' || of_get_option('sidebarliaborder', true) != '' ){
			echo "#sidebar ul li a{color:".of_get_option('sidebarfontcolor',true)."; border-bottom:1px dashed ".of_get_option('sidebarliaborder',true)."}";
		}		
		if( of_get_option('sidebarfonthvcolor',true) != '' ){
			echo "#sidebar ul li a:hover{color:".of_get_option('sidebarfonthvcolor',true)."; }";
		}	
// Slider title, description and button
		if( of_get_option('slidetitlefontface',true) != '' || of_get_option('slidetitlecolor',true) != '' || of_get_option('slidetitlefontsize',true) != '' || of_get_option('slidetitlebgcolor',true) != ''){
			echo ".slide_info h2{font-family:".of_get_option('slidetitlefontface').";color:".of_get_option('slidetitlecolor',true).";font-size:".of_get_option('slidetitlefontsize',true)."; background-color:".of_get_option('slidetitlebgcolor',true)."}";
		}
		if( of_get_option('slidedescfontface',true) != '' || of_get_option('slidedesccolor',true) != '' || of_get_option('slidedescfontsize',true) != '' || of_get_option('descfontstyle',true) != ''){
			echo ".slide_info p{font-family:".of_get_option('slidedescfontface').";color:".of_get_option('slidedesccolor',true).";font-size:".of_get_option('slidedescfontsize',true)."; font-style:".of_get_option('descfontstyle',true)."}";
		}
		$hdrhex = of_get_option('slidedescbgcolor',true); 
		list($r,$g,$b) = sscanf($hdrhex,'#%02x%02x%02x');
		if ( of_get_option('slidedescbgcolor', true) != '' ) {
			echo ".slide_info p{background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('descbgopacity',true).");}";
		}
if( of_get_option('slidebtnbgcolor',true) != '' || of_get_option('slidebtntxtcolor', true) != '' || of_get_option('slidebtnbordercolor', true) != ''){
			echo " {background-color:".of_get_option('slidebtnbgcolor',true)."; color:". of_get_option('btntxtcolor', true) ."; border-bottom:4px solid ". of_get_option('slidebtnbordercolor', true) ."; }";
		}
		if( of_get_option('slidebtnbgcolor',true) != '' ||  of_get_option('slidebtntxtcolor', true) != '' || of_get_option('slidebtnbordercolor', true) != ''){
			echo ".slide_info a.sldbutton {background-color:".of_get_option('slidebtnbgcolor',true)."; color:". of_get_option('slidebtntxtcolor', true) ."; border-color: ". of_get_option('slidebtnbordercolor', true) ."; }";
		}
		if ( of_get_option('copylinks', true) != '' ) {
		echo ".copyright-wrapper a{ color: ".of_get_option('copylinks', true)."; }";
		}	
		if ( of_get_option('copylinkshover', true) != '' ) {
		echo ".copyright-wrapper a:hover{ color: ".of_get_option('copylinkshover', true)."; }";
		}	
		if ( of_get_option('footerpostborder', true) != '' ) {
		echo ".recent-post{ border-bottom:1px dotted ".of_get_option('footerpostborder', true)."; }";
		}
		if ( of_get_option('footerpoststitle', true) != '' ) {
		echo ".recent-post h6{ color: ".of_get_option('footerpoststitle', true)."; }";
		}		
		if ( of_get_option('footerpoststitlehv', true) != '' ) {
		echo ".recent-post h6:hover{ color: ".of_get_option('footerpoststitlehv', true)."; }";
		}	
		if ( of_get_option('iframeborder', true) != '') {
		echo "iframe{ border:1px solid ".of_get_option('iframeborder', true)."; }";
		}		
		if ( of_get_option('sidebarbgcolor', true) != '' ) {
		echo "aside.widget{ background-color:".of_get_option('sidebarbgcolor', true)."; }";
		}	
	
		if ( of_get_option('togglemenu', true) != '' ) {
		echo ".toggle a{ background-color:".of_get_option('togglemenu', true)."; }";
		}
		if ( of_get_option('phoneiconcolor', true) != '' ) {
		echo ".signin_wrap .right .fa{ color:".of_get_option('phoneiconcolor', true)."; }";
		}
		if ( of_get_option('secborderbottom', true) != '' ) {
		echo "#wrapone, #wrapsecond, #ourclient{border-bottom:1px solid ".of_get_option('secborderbottom', true)."; }";
		}		
// Testimonials 
		if ( of_get_option('tmndescbgcolor', true) != '' ) {
		echo "#testimonials ul li .tm_description{background-color: ".of_get_option('tmndescbgcolor', true)."; }";
		}
		if ( of_get_option('tmn_titlefontcolor', true) != '' ) {
		echo "#testimonials ul li h6{ color: ".of_get_option('tmn_titlefontcolor', true)."; }";
		}		
		if ( of_get_option('tmnpagerbg', true) != '' ) {
		echo "ol.nav-numbers li a{background-color: ".of_get_option('tmnpagerbg', true)."; border:2px solid ".of_get_option('tmnpagerbg', true)."; }";
		}
		if ( of_get_option('tmnpagerbghv', true) != '' || of_get_option('tmnpagerbghv', true) != '' ) {
		echo "ol.nav-numbers li.active a{background-color: ".of_get_option('tmnpagerbghv', true)."; border:2px solid ".of_get_option('tmnpagerbgactive', true)."; }";
		}
		if ( of_get_option('tgmenuresponsivebg', true) != '' ) {
		echo "@media screen and (max-width: 1169px){.header .header-inner .nav{background-color: ".of_get_option('tgmenuresponsivebg', true).";}}";
		}
		
		/* Heading */
		if ( of_get_option('h1fontface', true) != '' ) {
			echo "h1{font-family:".of_get_option('h1fontface', true).";}";
		}	
		if ( of_get_option('h1fontsize', true) != '' ) {
			echo "h1{font-size:".of_get_option('h1fontsize', true).";}";
		}
		if ( of_get_option('sectiontitleboldcolor', true) != '' ) {
			echo "section h2 span{color:".of_get_option('sectiontitleboldcolor', true).";}";
		}

		if ( of_get_option('h1fontcolor', true) != '' ) {
			echo "h1{color:".of_get_option('h1fontcolor', true).";}";
		}
		if ( of_get_option('h2fontface', true) != '' ) {
			echo "h2{font-family:".of_get_option('h2fontface', true).";}";
		}	
		if ( of_get_option('h2fontsize', true) != '' ) {
			echo "h2{font-size:".of_get_option('h2fontsize', true).";}";
		}
		if ( of_get_option('h2fontcolor', true) != '' ) {
			echo "h2{color:".of_get_option('h2fontcolor', true).";}";
		}
		if ( of_get_option('h3fontface', true) != '' ) {
			echo "h3{font-family:".of_get_option('h3fontface', true).";}";
		}	
		if ( of_get_option('h3fontsize', true) != '' ) {
			echo "h3{font-size:".of_get_option('h3fontsize', true).";}";
		}
		if ( of_get_option('h3fontcolor', true) != '' ) {
			echo "h3{color:".of_get_option('h3fontcolor', true).";}";
		}
		if ( of_get_option('h4fontface', true) != '' ) {
			echo "h4{font-family:".of_get_option('h4fontface', true).";}";
		}	
		if ( of_get_option('h4fontsize', true) != '' ) {
			echo "h4{font-size:".of_get_option('h4fontsize', true).";}";
		}
		if ( of_get_option('h4fontcolor', true) != '' ) {
			echo "h4{color:".of_get_option('h4fontcolor', true).";}";
		}
		if ( of_get_option('h5fontface', true) != '' ) {
			echo "h5{font-family:".of_get_option('h5fontface', true).";}";
		}	
		if ( of_get_option('h5fontsize', true) != '' ) {
			echo "h5{font-size:".of_get_option('h5fontsize', true).";}";
		}
		if ( of_get_option('h5fontcolor', true) != '' ) {
			echo "h5{color:".of_get_option('h5fontcolor', true).";}";
		}
		if ( of_get_option('h6fontface', true) != '' ) {
			echo "h6{font-family:".of_get_option('h6fontface', true).";}";
		}	
		if ( of_get_option('h6fontsize', true) != '' ) {
			echo "h6{font-size:".of_get_option('h6fontsize', true).";}";
		}
		if ( of_get_option('h6fontcolor', true) != '' ) {
			echo "h6{color:".of_get_option('h6fontcolor', true).";}";
		}
		
		if ( of_get_option('logoheight', true) != '' ) {
			echo ".logo img{height:".of_get_option('logoheight', true)."px;}";
		}
		
		echo "</style>";
	}
}
add_action('wp_head', 'skt_yogi_custom_head_codes');


function skt_yogi_pagination() {
	global $wp_query;
	$big = 12345678;
	$page_format = paginate_links( array(
	    'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	    'format' => '?paged=%#%',
	    'current' => max( 1, get_query_var('paged') ),
	    'total' => $wp_query->max_num_pages,
	    'type'  => 'array'
	) );
	if( is_array($page_format) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $page_format as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	}
}
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';


/**
 * Load custom functions file.
 */
require get_template_directory() . '/inc/custom-functions.php';

function skt_yogi_custom_blogpost_pagination( $wp_query ){
	$big = 999999999; // need an unlikely integer
	if ( get_query_var('paged') ) { $pageVar = 'paged'; }
	elseif ( get_query_var('page') ) { $pageVar = 'page'; }
	else { $pageVar = 'paged'; }
	$pagin = paginate_links( array(
		'base' 			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		'format' 		=> '?'.$pageVar.'=%#%',
		'current' 		=> max( 1, get_query_var($pageVar) ),
		'total' 		=> $wp_query->max_num_pages,
		'prev_text'		=> '&laquo; Prev',
		'next_text' 	=> 'Next &raquo;',
		'type'  => 'array'
	) ); 
	if( is_array($pagin) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $pagin as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	} 
}
// get slug by id
function skt_yogi_get_slug_by_id($id) {
	$post_data = get_post($id, ARRAY_A);
	$slug = $post_data['post_name'];
	return $slug; 
}