<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

class Thrive_Theme_Style_Provider extends TCB_Style_Provider {

	/**
	 * @inheritDoc
	 *
	 * @param array $styles
	 */
	public function save_styles( $styles ) {
		thrive_typography()->set_style( $styles );
	}

	/**
	 * @inheritDoc
	 *
	 * @return array
	 */
	protected function read_styles() {
		return (array) thrive_typography()->get_style();
	}

	/**
	 * @inheritDoc
	 *
	 * @return array
	 */
	protected function defaults() {
		$defaults = parent::defaults();

		$link_prefixes = [
			'p',
			'li',
			'blockquote',
			'pre',
		];

		$defaults['link']['selector']      .= ', .tcb-post-content ' . implode( ' a, .tcb-post-content ', $link_prefixes ) . ' a';
		$defaults['plaintext']['selector'] = 'body';

		return $defaults;
	}
}
