<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

?>

<style>
	.ttb-container {
		margin: 24px auto;
		width: 680px;
		box-sizing: border-box;
		padding: 25px 90px 35px;
		background: white;
		border: 1px solid #e5e5e5;
		box-shadow: 0 1px 1px rgba(0, 0, 0, 0.04);
		position: relative;
	}
	.ttb-container h1 {
		margin: 0 0 30px;
	}
	.wp-core-ui .ttb-container .button {
		color: #fff;
		background-color: #cf2a27;
		border: none;
	}
	.ttb-center {
		text-align: center;
	}
	.ttb-mb30 {
		margin-bottom: 30px;
	}
</style>

<div class="ttb-container theme-overlay">
	<h1 class="ttb-center"><?php echo __( 'Reset your Theme', THEME_DOMAIN ); ?></h1>
	<p><?php echo __( 'Use the button below to reset your theme to its default state.', THEME_DOMAIN ); ?></p>
	<p class="ttb-mb30"><strong><?php echo __( "Warning: Resetting the theme will remove all custom templates that you've created and cannot be undone!", THEME_DOMAIN ); ?></strong></p>

	<p class="ttb-center ttb-mb30"><strong><?php echo __( 'Are you sure you want to reset your theme?', THEME_DOMAIN ); ?></strong></p>

	<div class="ttb-center">
		<button style="display: none;" data-action="ttb_skin_reset" class="button button-primary button-large ttb-action-button">
			<?php echo __( 'Yes, I want to Reset the Theme', THEME_DOMAIN ); ?>
		</button>
		<button data-action="ttb_factory_reset" class="button ttb-action-button delete-theme">
			<?php echo __( 'Remove all data from the theme builder', THEME_DOMAIN ); ?>
		</button>
	</div>
</div>

<script type="text/javascript">
	( function ( $ ) {
		$( '.ttb-action-button' ).click( function () {
			$.ajax( {
				url: ajaxurl,
				type: 'post',
				data: {
					action: this.dataset.action
				}
			} ).always( function ( response ) {
				alert( response );
			} )
		} );
	} )( jQuery )
</script>
